CREATE TRIGGER "tub_pv_kanne_kulum" BEFORE UPDATE
ORDER 1 ON "DBA"."pv_kanne_kulum"
REFERENCING OLD AS old_name NEW AS new_name
FOR EACH ROW
BEGIN
  declare ld_kuup date;
  declare ld_today date;
  declare ll_yksusnr integer;
  set ld_kuup=ymd(new_name.aasta,new_name.kuu,1);
  set ld_today=get_perlop(ToDay());
  select pv_kanne.yksusnr into ll_yksusnr from pv_kanne where pv_kanne."id"=new_name."id";
  while ld_kuup<=ld_today loop
    if years(ld_kuup)>2020 then
      call pr_kanne_add(month(ld_kuup),years(ld_kuup),ll_yksusnr,6);
    end if;
    set ld_kuup=dateadd(month,1,ld_kuup);
  end loop;
END