ALTER TRIGGER "tub_pv_kanne_column1" BEFORE UPDATE OF "alg_m", "ytk"
ORDER 1 ON "DBA"."pv_kanne"
REFERENCING OLD AS old_name NEW AS new_name
FOR EACH ROW
BEGIN
  declare ld_kuup date;
  declare ld_today date;
  if new_name.kuup<old_name.kuup then
    set ld_kuup=new_name.kuup
  else
    set ld_kuup=old_name.kuup
  end if;
  set ld_today=get_perlop(ToDay());
  while ld_kuup<=ld_today loop
    if years(ld_kuup)>2020 then
      call pr_kanne_add(month(ld_kuup),years(ld_kuup),new_name.yksusnr,6);
    end if;
    set ld_kuup=dateadd(month,1,ld_kuup);
  end loop;
END