ALTER PROCEDURE "dba"."pv_koond_web"( in a_skoop char(100) default '', in a_org char(100) default '', in a_yksus char(100) default '', in a_asut char(101) default '', in a_toot_nr char(100) default '', in a_objnr2 integer default 0, in a_modified char(30) default ''  )
RESULT( valdkond char(100), organisatsioon char(100), vastutaja char(101), konto char(7), konto_nimi char(100), allyksus char(100), yldnimi char(200), inv_id integer, inv_number char(20), nimi char(100), kuup date, summa decimal(15,2), invent char(100), rfid char(100), mahakantud char(30))
BEGIN
  declare ld_perlop date;
  declare ll_count integer;
  declare ll_skoop integer;
  declare ls_skoopkood char(16);
  declare ll_orgnr integer;
  declare ls_orgkood char(16);
  declare ll_yksusnr integer;
  declare ls_yksuskood char(16);
  declare ll_asutnr integer;
  declare ldt_modified timestamp;
  set ld_perlop=ToDay();
  -- muudatuste piirang
  if Length(a_modified)>0 then
    set ldt_modified=Datetime(a_modified)
  end if;
  if ldt_modified is null then
    set ldt_modified=Datetime('1901-01-01 12:12:12.000')
  end if;
  -- Valdkonna tuvastamine
  if a_skoop is null then
    set a_skoop=''
  end if;
  set ll_count=0;
  set ll_skoop=null;
  set ls_skoopkood='';
  if Length(a_skoop)>0 then
    select first skoop into ll_skoop from skoobid where nimi=a_skoop;
    if ll_skoop is null then
      select count() into ll_count from skoobid where Left(kood,Length(a_skoop))=a_skoop;
      if ll_count=0 then
        set ll_skoop=0
      else
        if ll_count=1 then
          select first skoop into ll_skoop from skoobid where Left(kood,Length(a_skoop))=a_skoop
        else
          set ls_skoopkood=a_skoop;
          set ll_skoop=0
        end if
      end if
    end if
  else
    set ll_skoop=0
  end if;
  -- Organisatsiooni tuvastamine
  if a_org is null then
    set a_org=''
  end if;
  set ll_count=0;
  set ll_orgnr=null;
  set ls_orgkood='';
  if Length(a_org)>0 then
    select first orgnr into ll_orgnr from orglist where nimi=a_org;
    if ll_orgnr is null then
      select count() into ll_count from orglist where Left(kood,Length(a_org))=a_org;
      if ll_count=0 then
        set ll_orgnr=0
      else
        if ll_count=1 then
          select first orgnr into ll_orgnr from orglist where Left(kood,Length(a_org))=a_org
        else
          set ls_orgkood=a_org;
          set ll_orgnr=0
        end if
      end if
    end if
  else
    set ll_orgnr=0
  end if;
  -- Allyksuse tuvastamine
  if a_yksus is null then
    set a_yksus=''
  end if;
  set ll_count=0;
  set ll_yksusnr=null;
  set ls_yksuskood='';
  if Length(a_yksus)>0 then
    select first pv_yksus.yksusnr into ll_yksusnr
      from pv_yksus left outer join skoobid on pv_yksus.skoop=skoobid.skoop
                    left outer join orglist on pv_yksus.orgnr=orglist.orgnr
      where pv_yksus.nimi=a_yksus and
           (pv_yksus.skoop=ll_skoop or ll_skoop=0) and Left(skoobid.kood,Length(ls_skoopkood))=ls_skoopkood and
           (ll_orgnr=0 and pv_yksus.orgnr is null or ((pv_yksus.orgnr=ll_orgnr or ll_orgnr=0) and Left(orglist.kood,Length(ls_orgkood))=ls_orgkood));
    if ll_yksusnr is null then
      select count() into ll_count
        from pv_yksus left outer join skoobid on pv_yksus.skoop=skoobid.skoop
                      left outer join orglist on pv_yksus.orgnr=orglist.orgnr
        where Left(pv_yksus.kood,Length(a_yksus))=a_yksus and
             (pv_yksus.skoop=ll_skoop or ll_skoop=0) and Left(skoobid.kood,Length(ls_skoopkood))=ls_skoopkood and
             (ll_orgnr=0 and pv_yksus.orgnr is null or ((pv_yksus.orgnr=ll_orgnr or ll_orgnr=0) and Left(orglist.kood,Length(ls_orgkood))=ls_orgkood));
      if ll_count=0 then
        set ll_yksusnr=0
      else
        if ll_count=1 then
          select first pv_yksus.yksusnr into ll_yksusnr
            from pv_yksus left outer join skoobid on pv_yksus.skoop=skoobid.skoop
                          left outer join orglist on pv_yksus.orgnr=orglist.orgnr
            where Left(pv_yksus.kood,Length(a_yksus))=a_yksus and
                 (pv_yksus.skoop=ll_skoop or ll_skoop=0) and Left(skoobid.kood,Length(ls_skoopkood))=ls_skoopkood and
                 (ll_orgnr=0 and pv_yksus.orgnr is null or ((pv_yksus.orgnr=ll_orgnr or ll_orgnr=0) and Left(orglist.kood,Length(ls_orgkood))=ls_orgkood));
        else
          set ls_yksuskood=a_yksus;
          set ll_yksusnr=0
        end if
      end if
    end if
  else
    set ll_yksusnr=0
  end if;
  -- Mat.vastutaja tuvastamine
  if a_asut is null then
    set a_asut=''
  end if;
  set ll_asutnr=null;
  if Length(a_asut)>0 then
    select first asutnr into ll_asutnr from asulist where get_asulist_nimi_quick(asutnr)=a_asut;
    if ll_asutnr is null then
      select first asutnr into ll_asutnr from asulist where reg_nr=a_asut;
    end if
  end if;
  if ll_asutnr is null then
    set ll_asutnr=0
  end if;
  -- Inventari number
  if a_toot_nr is null then
    set a_toot_nr=''
  end if;
  set a_toot_nr=Left(a_toot_nr,20);


  delete from gl_pv_kanne;
  insert into gl_pv_kanne(id,yksusnr,toot_nr,nimi,yldnimi,kuup,alg_m,invent,rfid,kuup2)
    select pv_kanne."id",
           pv_kanne.yksusnr,
           if pv_kanne.toot_nr is null then '' else pv_kanne.toot_nr endif,
           pv_kanne.nimi,
           if pv_kanne.yldnimnr is null then pv_kanne.nimi else Trim(pv_kanne_muuinfo.yldnimi) endif,
           pv_kanne.kuup,
           pv_kanne.alg_m,
           pv_kanne.invent,
           pv_kanne.rfid,
           if pv_kanne.objnr2 is null then null else pv_kanne.kuup2 endif
      from pv_kanne left outer join pv_yksus on pv_kanne.yksusnr=pv_yksus.yksusnr
                    left outer join skoobid on pv_yksus.skoop=skoobid.skoop
                    left outer join orglist on pv_yksus.orgnr=orglist.orgnr
                    left outer join pv_kanne_muuinfo on pv_kanne.yldnimnr=pv_kanne_muuinfo."id"
      where
            (pv_yksus.skoop=ll_skoop or ll_skoop=0) and Left(skoobid.kood,Length(ls_skoopkood))=ls_skoopkood and
            (ll_orgnr=0 and pv_yksus.orgnr is null or ((pv_yksus.orgnr=ll_orgnr or ll_orgnr=0) and (Left(orglist.kood,Length(ls_orgkood))=ls_orgkood or Length(ls_orgkood)='' and orglist.kood is null))) and
            (pv_yksus.asutnr=ll_asutnr or ll_asutnr=0 or ll_asutnr=0 and pv_yksus.asutnr is null) and
            (pv_kanne.yksusnr=ll_yksusnr or ll_yksusnr=0) and Left(pv_yksus.kood,Length(ls_yksuskood))=ls_yksuskood and
            (Length(a_toot_nr)='' or pv_kanne.toot_nr=a_toot_nr) and
            if pv_kanne.kell2 is null then pv_kanne.kell else pv_kanne.kell2 endif >= ldt_modified and
            (pv_kanne.objnr2 is null or(pv_kanne.objnr2 is not null and pv_kanne.kuup2>ld_perlop) or a_objnr2>0);
  -- result
  select skoobid.nimi,
         orglist.nimi,
         get_asulist_nimi_quick(pv_yksus.asutnr) as asulist_nimi,
         if pv_yksus.konto is null then 'Varad' else pv_yksus.konto endif as konto,
         if pv_yksus.konto is null then 'Muud varad' else kontlist.nimi endif as konto_nimi,
         pv_yksus.nimi,
         gl_pv_kanne.yldnimi,
         gl_pv_kanne."id",
         gl_pv_kanne.toot_nr,
         gl_pv_kanne.nimi,
         gl_pv_kanne.kuup,
         gl_pv_kanne.alg_m,
         if gl_pv_kanne.invent is null then '' else convert(char(100),gl_pv_kanne.invent) endif,
         if gl_pv_kanne.rfid is null then '' else gl_pv_kanne.rfid endif,
         if gl_pv_kanne.kuup2 is null then '' else convert(char(30),gl_pv_kanne.kuup2,104) endif
    from gl_pv_kanne left outer join pv_yksus on gl_pv_kanne.yksusnr = pv_yksus.yksusnr
                     left outer join skoobid on pv_yksus.skoop=skoobid.skoop
                     left outer join orglist on pv_yksus.orgnr=orglist.orgnr
                     left outer join kontlist on pv_yksus.konto=kontlist.konto
    order by skoobid.nimi,orglist.nimi,asulist_nimi,konto,konto_nimi,pv_yksus.nimi,gl_pv_kanne.yldnimi,gl_pv_kanne.nimi;
END