CREATE PROCEDURE "DBA"."pv_koond1_nimekiri2"( in a_skoop integer,in a_yksusnr integer,in a_yksuskood char(16),in a_paring integer,in a_perlop date)
BEGIN
  declare ls_konto char(7);
  declare ls_toot_nr char(20);
  declare ls_vara_nr char(10);
  declare ls_nimi char(100);
  declare ls_info char(250);
  declare ld_invent timestamp;
  declare ld_kuup date;
  declare ld_ekspl date;
  declare ldc_summa numeric(15,2);
  declare ldc_raamat_summa numeric(15,2);
  declare ldc_teg_summa numeric(15,2);
  declare ldc_kogus numeric(15,3);
  declare ldc_raamat_kogus numeric(15,3);
  declare ldc_teg_kogus numeric(15,3);
  declare ldc_epk decimal(15,2);
  declare ldc_jpk1 decimal(15,2);
  declare ldc_jpk2 decimal(15,2);
  declare ldc_jpk decimal(15,2);
  declare ldc_piir_min decimal(15,2);
  declare ldc_piir_max decimal(15,2);
  declare ldc_kulu_p numeric(10,3);
  declare li_yksusnr integer;
  declare li_id integer;
  declare li_find integer;
  declare li_pvkont smallint;
  declare li_paring integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_pv_kanne dynamic scroll cursor for
        select pv_kanne.id,
               pv_kanne.yksusnr,
               if pv_yksus.konto is null then '       ' else pv_yksus.konto endif,
               if pv_kanne.toot_nr is null or trim(pv_kanne.toot_nr) = '' then '                    ' else pv_kanne.toot_nr endif,
               pv_kanne.vara_nr,
               pv_kanne.nimi,
               get_pv_protsent("pv_kanne"."id",years(a_perlop),month(a_perlop)),
               pv_kanne.kuup,
               pv_kanne.ekspl,
               if pv_kanne.kogus is null then 1 else pv_kanne.kogus endif,
               pv_kanne.alg_m,
               pv_epk(pv_kanne.id,years(a_perlop)) as epk,
               pv_jpk(pv_kanne.id,years(a_perlop),month(a_perlop)-1,epk)+(if years(pv_kanne.kuup)=years(a_perlop) and pv_kanne.kuup<ymd(Years(a_perlop),Month(a_perlop),1) then pv_kanne.ytk else 0 endif) as jpk1,
               pv_jpk(pv_kanne.id,years(a_perlop),month(a_perlop),epk)+(if years(pv_kanne.kuup)=years(a_perlop) and pv_kanne.kuup<ymd(Years(a_perlop),Month(a_perlop)+1,1) then pv_kanne.ytk else 0 endif) as jpk2
             from pv_kanne left outer join gl_1 on(pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup) left outer join pv_yksus on pv_kanne.yksusnr = pv_yksus.yksusnr
             where((pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup) or a_paring = 0) and(pv_yksus.skoop = a_skoop or a_skoop = 0) and(pv_kanne.yksusnr = a_yksusnr or a_yksusnr = 0) and Left(pv_yksus.kood,Length(a_yksuskood))=a_yksuskood and pv_kanne.kuup <= a_perlop and(pv_kanne.objnr2 is null or pv_kanne.kuup2 > a_perlop)
             order by "pv_kanne"."id" asc;
  delete from gl_pv_kanne;
  select "yld_pvkont","tr_nim_piir_min","tr_nim_piir_max" into li_pvkont,ldc_piir_min,ldc_piir_max from "pv_konfm" where "id"=1;
  set li_paring=set_gl_1(a_paring);
  open c_pv_kanne;
  pv_kanne_loop: loop
    fetch next c_pv_kanne into li_id,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ldc_kulu_p,ld_kuup,ld_ekspl,ldc_kogus,ldc_summa,ldc_epk,ldc_jpk1,ldc_jpk2;
    if sqlstate = err_notfound then -- kui eof
      leave pv_kanne_loop
    end if;
    -- kas kanne ei eksisteeri koondis
    if (ls_konto = '       ' and li_pvkont=1) or (ls_toot_nr = '                    ') or not exists(select 1 from gl_pv_kanne where gl_pv_kanne.toot_nr = ls_toot_nr and (gl_pv_kanne.konto = ls_konto or li_pvkont=0)) then
      insert into gl_pv_kanne( id,yksusnr,konto,toot_nr,vara_nr,nimi,kulu_p,kuup,ekspl,kogus,alg_m)
                       values( li_id,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ldc_kulu_p,ld_kuup,ld_ekspl,ldc_kogus,0);
      set li_find=li_id
    else
      select gl_pv_kanne."id" into li_find from gl_pv_kanne where gl_pv_kanne.toot_nr = ls_toot_nr and gl_pv_kanne.konto = ls_konto
    end if;
    -- summeerimine
    update gl_pv_kanne set alg_m=alg_m+ldc_summa,mjm=mjm+(ldc_summa-ldc_epk-ldc_jpk2) where gl_pv_kanne.id = li_find;
  end loop pv_kanne_loop;
  close c_pv_kanne;
  -- kustutamine
  delete from gl_pv_kanne where alg_m<ldc_piir_min or alg_m>=ldc_piir_max;
END