CREATE VIEW "DBA"."pr_tulkul_kanne_view1"( "PMen id", "Aasta", "Kande kuupev", "Pearaamatu summa", "Dok.nr.", "Alus/info", "Asutus/isik", "Mem.order", "Deebet", "D TP-kood", "Kreedit", "K TP-kood", "Tegevusala kood", "Tegevusala nimi", "Kulu liik", "Tulu liik", "Projekti kood", "Projekti nimi", "Osakonna kood", "Osakonna nimi", "Subjekti kood", "Subjekti nimi", "Tegevussuuna kood", "Tegevussuuna nimi", "Tulnud", "Kasutaja" )
AS
select pr_kanne."id",pr_kanne.aasta,pr_kanne.kuup,
       if kontlist_a.kulukonto=1 then -1*pr_kanne.summa else pr_kanne.summa endif,
       pr_kanne.doknr,
       trim(pr_alus.nimi+' '+pr_kanne."info"),
       get_asulist_nimi_quick(pr_kanne.asutnr),
       pr_kanne."order",
       pr_kanne.deeb,partlist_a.part,
       pr_kanne.kree,partlist_b.part,
       tallist.osa,tallist.nimi,artlist.art,tullist.osa,objlist."object",objlist.nimi,osaklist.osak,osaklist.nimi,sublist.subject,sublist.nimi,suundlist.suund,suundlist.nimi,
       pr_kanne.tulnud,t_user.username
  from pr_kanne left outer join kontlist as kontlist_a on pr_kanne.deeb=kontlist_a.konto
                left outer join kontlist as kontlist_b on pr_kanne.kree=kontlist_b.konto
                left outer join pr_alus on pr_kanne.alusnr=pr_alus.alusnr
                left outer join partlist as partlist_a on pr_kanne.partnr=partlist_a.partnr
                left outer join partlist as partlist_b on pr_kanne.partnr2=partlist_b.partnr
                left outer join tallist on pr_kanne.talnr=tallist.talnr
                left outer join artlist on pr_kanne.artnr=artlist.artnr
                left outer join tullist on pr_kanne.tulnr=tullist.tulnr
                left outer join objlist on pr_kanne.objectnr=objlist.objectnr
                left outer join osaklist on pr_kanne.osaknr=osaklist.osaknr
                left outer join sublist on pr_kanne.subjectnr=sublist.subjectnr
                left outer join suundlist on pr_kanne.suundnr=suundlist.suundnr
                left outer join t_user on pr_kanne.user_code=t_user.id_user
  where (pr_kanne.deeb is not null and kontlist_a.kulukonto=1 or pr_kanne.kree is not null and kontlist_b.kulukonto=1) and
        (pr_kanne.deeb is null or pr_kanne.kree is null or kontlist_a.kulukonto<>kontlist_b.kulukonto) and
        (pr_kanne.artnr is not null or pr_kanne.tulnr is not null) and
         pr_kanne.objectnr is not null