ALTER PROCEDURE "DBA"."pr_tulkul_kanne"( in a_aasta numeric(4) default 2018, in a_skoop integer default 0 )
RESULT( id_kanne integer, aasta integer, tulnud char(100), doknr char(20), kuup date, summa decimal(15,2), "info" char(300), asulist_regkood char(11), asulist_nimi char(110), mem_order char(3), konto char(7), tehingupartner char(16), meede char(16), kuluobjekt char(16), tegevusala char(16), kululiik char(16), tululiik char(16), projekt char(16), osakond char(16), subjekt char(16), tegevussuund char(16), taotlus char(16), allikas char(16), rahavoog char(16), kell timestamp, kell2 timestamp )
BEGIN
  delete from gl_pr_kanne;
  if a_skoop is null then
    set a_skoop=0
  end if;
  insert into gl_pr_kanne (id_kanne,aasta,tulnud,doknr,kuup,summa,"info","order",asutnr,konto,partnr,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,kell,kell2)
    select pr_kanne.id,pr_kanne.aasta,'pr_kanne',pr_kanne.doknr,
           pr_kanne.kuup,pr_kanne.summa,
           trim(pr_alus.nimi+' '+pr_kanne."info"),
           pr_kanne."order",pr_kanne.asutnr,pr_kanne.deeb,pr_kanne.partnr,
           pr_kanne.meetnr,pr_kanne.kulnr,pr_kanne.talnr,pr_kanne.artnr,pr_kanne.tulnr,pr_kanne.objectnr,pr_kanne.osaknr,pr_kanne.subjectnr,pr_kanne.suundnr,pr_kanne.taotnr,pr_kanne.alliknr,pr_kanne.ravonr,pr_kanne.kell,pr_kanne.kell2
      from pr_kanne left outer join kontlist on pr_kanne.deeb=kontlist.konto
                    left outer join pr_alus on pr_kanne.alusnr=pr_alus.alusnr
      where pr_kanne.aasta=a_aasta and (pr_kanne.skoop=a_skoop or a_skoop=0) and pr_kanne.deeb is not null and kontlist.kulukonto=1 and pr_kanne.artnr is not null;
  insert into gl_pr_kanne (id_kanne,aasta,tulnud,doknr,kuup,summa,"info","order",asutnr,konto,partnr,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,kell,kell2)
    select pr_kanne.id,pr_kanne.aasta,'pr_kanne',pr_kanne.doknr,
           pr_kanne.kuup,-1*pr_kanne.summa,
           trim(pr_alus.nimi+' '+pr_kanne."info"),
           pr_kanne."order",pr_kanne.asutnr,pr_kanne.kree,pr_kanne.partnr2,
           pr_kanne.meetnr,pr_kanne.kulnr,pr_kanne.talnr,pr_kanne.artnr,pr_kanne.tulnr,pr_kanne.objectnr,pr_kanne.osaknr,pr_kanne.subjectnr,pr_kanne.suundnr,pr_kanne.taotnr,pr_kanne.alliknr,pr_kanne.ravonr,pr_kanne.kell,pr_kanne.kell2
      from pr_kanne left outer join kontlist on pr_kanne.kree=kontlist.konto
                    left outer join pr_alus on pr_kanne.alusnr=pr_alus.alusnr
      where pr_kanne.aasta=a_aasta and (pr_kanne.skoop=a_skoop or a_skoop=0) and pr_kanne.kree is not null and kontlist.kulukonto=1 and pr_kanne.artnr is not null;
  insert into gl_pr_kanne (id_kanne,aasta,tulnud,doknr,kuup,summa,"info","order",asutnr,konto,partnr,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,kell,kell2)
    select pr_kanne.id,pr_kanne.aasta,'pr_kanne',pr_kanne.doknr,
           pr_kanne.kuup,-1*pr_kanne.summa,
           trim(pr_alus.nimi+' '+pr_kanne."info"),
           pr_kanne."order",pr_kanne.asutnr,pr_kanne.deeb,pr_kanne.partnr,
           pr_kanne.meetnr,pr_kanne.kulnr,pr_kanne.talnr,pr_kanne.artnr,pr_kanne.tulnr,pr_kanne.objectnr,pr_kanne.osaknr,pr_kanne.subjectnr,pr_kanne.suundnr,pr_kanne.taotnr,pr_kanne.alliknr,pr_kanne.ravonr,pr_kanne.kell,pr_kanne.kell2
      from pr_kanne left outer join kontlist on pr_kanne.deeb=kontlist.konto
                    left outer join pr_alus on pr_kanne.alusnr=pr_alus.alusnr
      where pr_kanne.aasta=a_aasta and (pr_kanne.skoop=a_skoop or a_skoop=0) and pr_kanne.deeb is not null and kontlist.kulukonto=1 and pr_kanne.artnr is null and pr_kanne.tulnr is not null;
  insert into gl_pr_kanne (id_kanne,aasta,tulnud,doknr,kuup,summa,"info","order",asutnr,konto,partnr,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,kell,kell2)
    select pr_kanne.id,pr_kanne.aasta,'pr_kanne',pr_kanne.doknr,
           pr_kanne.kuup,pr_kanne.summa,
           trim(pr_alus.nimi+' '+pr_kanne."info"),
           pr_kanne."order",pr_kanne.asutnr,pr_kanne.kree,pr_kanne.partnr2,
           pr_kanne.meetnr,pr_kanne.kulnr,pr_kanne.talnr,pr_kanne.artnr,pr_kanne.tulnr,pr_kanne.objectnr,pr_kanne.osaknr,pr_kanne.subjectnr,pr_kanne.suundnr,pr_kanne.taotnr,pr_kanne.alliknr,pr_kanne.ravonr,pr_kanne.kell,pr_kanne.kell2
      from pr_kanne left outer join kontlist on pr_kanne.kree=kontlist.konto
                    left outer join pr_alus on pr_kanne.alusnr=pr_alus.alusnr
      where pr_kanne.aasta=a_aasta and (pr_kanne.skoop=a_skoop or a_skoop=0) and pr_kanne.kree is not null and kontlist.kulukonto=1 and pr_kanne.artnr is null and pr_kanne.tulnr is not null;
  select id_kanne,aasta,tulnud,gl_pr_kanne.doknr,kuup,summa,"info",'','',"order",konto,partlist.part,meetlist.meet,kullist.ptk,tallist.osa,artlist.art,tullist.osa,objlist."object",osaklist.osak,sublist.subject,suundlist.suund,taotlist.taot,alliklist.allik,ravolist.ravo,gl_pr_kanne.kell,gl_pr_kanne.kell2
    from gl_pr_kanne left outer join partlist on gl_pr_kanne.partnr=partlist.partnr
                     left outer join meetlist on gl_pr_kanne.meetnr=meetlist.meetnr
                     left outer join kullist on gl_pr_kanne.kulnr=kullist.kulnr
                     left outer join tallist on gl_pr_kanne.talnr=tallist.talnr
                     left outer join artlist on gl_pr_kanne.artnr=artlist.artnr
                     left outer join tullist on gl_pr_kanne.tulnr=tullist.tulnr
                     left outer join objlist on gl_pr_kanne.objectnr=objlist.objectnr
                     left outer join osaklist on gl_pr_kanne.osaknr=osaklist.osaknr
                     left outer join sublist on gl_pr_kanne.subjectnr=sublist.subjectnr
                     left outer join suundlist on gl_pr_kanne.suundnr=suundlist.suundnr
                     left outer join taotlist on gl_pr_kanne.taotnr=taotlist.taotnr
                     left outer join alliklist on gl_pr_kanne.alliknr=alliklist.alliknr
                     left outer join ravolist on gl_pr_kanne.ravonr=ravolist.ravonr;
                     
END