ALTER PROCEDURE "DBA"."pr_anal_arveld"(in id_skoop integer,in perlop date, in a_konto char(7))
begin
  declare li_saldod smallint;
  declare li_asutusisik smallint;
  delete from gl_dk_koond;
  delete from gl_pr_koond;
  if exists(select 1 from dk_obj where dk_obj.skoop=id_skoop and dk_obj.djkonto=a_konto) then
-- Arveldused
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,adeeb,akree) 
      select '1',
             if asulist.partnr is null then 0 else asulist.partnr endif,
             if dk_kanne.asutnr is null then 0 else dk_kanne.asutnr endif,
             if dk_kanne.talnr is null then 0 else dk_kanne.talnr endif,
             if dk_kanne.alliknr is null then 0 else dk_kanne.alliknr endif,
             if dk_kanne.ravonr is null then 0 else dk_kanne.ravonr endif,
             sum(if dk_kanne.sisse = 1 then dk_kanne.summa+dk_kanne.summa2 else 0 endif),
             sum(if dk_kanne.sisse = 0 then dk_kanne.summa+dk_kanne.summa2 else 0 endif)
        from dk_kanne key left outer join dk_obj left outer join asulist on dk_kanne.asutnr=asulist.asutnr
        where (dk_obj.skoop=id_skoop) and dk_obj.djkonto=a_konto and dk_kanne.asutnr is not null and dk_kanne.kuup <= perlop
        group by asulist.partnr,dk_kanne.asutnr,dk_kanne.talnr,dk_kanne.alliknr,dk_kanne.ravonr;
-- Kassa/pank
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,adeeb,akree) 
      select '2',
             if asulist.partnr is null then 0 else asulist.partnr endif,
             if kp_kanne.asutnr is null then 0 else kp_kanne.asutnr endif,
             if kp_kanne.talnr is null then 0 else kp_kanne.talnr endif,
             if kp_kanne.alliknr is null then 0 else kp_kanne.alliknr endif,
             if kp_kanne.ravonr is null then 0 else kp_kanne.ravonr endif,
             sum(if kp_kanne.sisse = 0 then kp_kanne.summa else 0 endif),
             sum(if kp_kanne.sisse = 1 then kp_kanne.summa else 0 endif)
        from kp_kanne left outer join kp_obj on kp_kanne.objnr = kp_obj.objnr left outer join asulist on kp_kanne.asutnr=asulist.asutnr
        where (kp_obj.skoop = id_skoop) and kp_kanne.konto=a_konto and kp_kanne.asutnr is not null and kp_kanne.kuup <= perlop
        group by asulist.partnr,kp_kanne.asutnr,kp_kanne.talnr,kp_kanne.alliknr,kp_kanne.ravonr;
  end  if;
-- Pearaamat
  select pr_konfm.yld_saldod,pr_konfm.yld_asutusisik into li_saldod,li_asutusisik from pr_konfm where pr_konfm.id = 1;
  if li_saldod=1 and locate('345678',"left"(a_konto,1)) > 0 then
-- Deebet
    insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,deeb)
        select '7',
               if pr_kanne.partnr is null then 0 else pr_kanne.partnr endif,
               if pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif,
               if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
               if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
               if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
               sum(pr_kanne.summa)
          from pr_kanne
          where (pr_kanne.skoop = id_skoop) and pr_kanne.deeb=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) = years(perlop)
          group by pr_kanne.partnr,pr_kanne.asutnr,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
-- Kreedit
    insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,kree)
        select '8',
               if pr_kanne.partnr2 is null then 0 else pr_kanne.partnr2 endif,
               if pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif,
               if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
               if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
               if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
               sum(pr_kanne.summa)
          from pr_kanne
          where (pr_kanne.skoop = id_skoop) and pr_kanne.kree=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) = years(perlop)
          group by pr_kanne.partnr2,pr_kanne.asutnr,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
  else
    -- aasta 2016 alguseni, kui asutus/isik nullida
-- Deebet
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,deeb)
      select '3',
             if pr_kanne.partnr is null then 0 else pr_kanne.partnr endif,
             if li_asutusisik=1 or pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif as asutnr1,
             if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
             if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
             if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
             sum(pr_kanne.summa)
        from pr_kanne
        where (pr_kanne.skoop = id_skoop) and pr_kanne.deeb=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) < 2016
        group by pr_kanne.partnr,asutnr1,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
-- Kreedit
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,kree)
      select '4',
             if pr_kanne.partnr2 is null then 0 else pr_kanne.partnr2 endif,
             if li_asutusisik=1 or pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif as asutnr1,
             if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
             if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
             if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
             sum(pr_kanne.summa)
        from pr_kanne
        where (pr_kanne.skoop = id_skoop) and pr_kanne.kree=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) < 2016
        group by pr_kanne.partnr2,asutnr1,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
-- Deebet
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,deeb)
      select '5',
             if pr_kanne.partnr is null then 0 else pr_kanne.partnr endif,
             if pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif,
             if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
             if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
             if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
             sum(pr_kanne.summa)
        from pr_kanne
        where (pr_kanne.skoop = id_skoop) and pr_kanne.deeb=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) > 2015
        group by pr_kanne.partnr,pr_kanne.asutnr,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
-- Kreedit
  insert into gl_pr_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,kree)
      select '6',
             if pr_kanne.partnr2 is null then 0 else pr_kanne.partnr2 endif,
             if pr_kanne.asutnr is null then 0 else pr_kanne.asutnr endif,
             if pr_kanne.talnr is null then 0 else pr_kanne.talnr endif,
             if pr_kanne.alliknr is null then 0 else pr_kanne.alliknr endif,
             if pr_kanne.ravonr is null then 0 else pr_kanne.ravonr endif,
             sum(pr_kanne.summa)
        from pr_kanne
        where (pr_kanne.skoop = id_skoop) and pr_kanne.kree=a_konto and pr_kanne.kuup <= perlop and years(pr_kanne.kuup) > 2015
        group by pr_kanne.partnr2,pr_kanne.asutnr,pr_kanne.talnr,pr_kanne.alliknr,pr_kanne.ravonr;
  end if;
  -- nulli asutus
  update gl_pr_koond left outer join partlist on gl_pr_koond.partnr = partlist.partnr set asutnr=0 where Left(partlist.part,6)='800699' or Left(partlist.part,1)='9';
  -- koond
  insert into gl_dk_koond( konto,partnr,asutnr,talnr,alliknr,ravonr,adeeb,akree,deeb,kree) 
    select '5',gl_pr_koond.partnr,gl_pr_koond.asutnr,gl_pr_koond.talnr,gl_pr_koond.alliknr,gl_pr_koond.ravonr,sum(gl_pr_koond.adeeb),sum(gl_pr_koond.akree),sum(gl_pr_koond.deeb),sum(gl_pr_koond.kree)
      from gl_pr_koond
      group by gl_pr_koond.partnr,gl_pr_koond.asutnr,gl_pr_koond.talnr,gl_pr_koond.alliknr,gl_pr_koond.ravonr;
  -- loppjaagid
  update gl_dk_koond set adeeb = adeeb-akree,akree = akree-adeeb;
  update gl_dk_koond set adeeb = 0 where gl_dk_koond.adeeb < 0;
  update gl_dk_koond set akree = 0 where gl_dk_koond.akree < 0;
  update gl_dk_koond set deeb = deeb-kree,kree = kree-deeb;
  update gl_dk_koond set deeb = 0 where gl_dk_koond.deeb < 0;
  update gl_dk_koond set kree = 0 where gl_dk_koond.kree < 0;
  update gl_dk_koond set ldeeb=adeeb-akree-deeb+kree,lkree=akree-adeeb-kree+deeb;
  update gl_dk_koond set ldeeb = 0 where ldeeb < 0;
  update gl_dk_koond set lkree = 0 where lkree < 0;
  delete from gl_dk_koond where adeeb = 0 and akree = 0 and deeb = 0 and kree = 0;
end