CREATE PROCEDURE "DBA"."pa_stat_koond2"( in a_skoopkood char(16), in a_skoop integer, in a_yksuskood char(16), in a_yksusnr integer, in a_a_akuu numeric(2), in a_a_aasta char(4), in a_statnr integer default 0)
BEGIN
  declare ld_peralg date;
  declare ld_perlop date;
  declare ldc_tpa_kuus decimal(15,2);
  declare ldc_kpa_kuus_pta decimal(15,2);
  declare ldc_1 decimal(15,2);
  declare ldc_2 decimal(15,2);
  declare ldc_3 decimal(15,2);
  declare ls_insert char(1500);
  declare ls_periood char(100);
  declare ls_productversion char(100);
  set ld_peralg=ymd(a_a_aasta,a_a_akuu,1);
  set ld_perlop=get_perlop(ymd(a_a_aasta,a_a_akuu,28));
  set ldc_tpa_kuus=get_tp_arv_per(ld_peralg,ld_perlop);
  set ldc_kpa_kuus_pta=get_kp_arv_per_pta(ld_peralg,ld_perlop);
  set ls_periood='pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu';
  delete from gl_pa_stat;
  delete from gl_list;
  insert into gl_list("id","id1","sum1","kuup1","kuup2")
    select distinct pa_leping.lepnr,pa_leping.id_koht,get_pa_leping_tun_koht(pa_leping.lepnr,ld_perlop) as pa_leping_tun_koht,if pa_leping.kuup1>ld_peralg then pa_leping.kuup1 else ld_peralg endif, if pa_leping.kuup2 is null or pa_leping.kuup2>ld_perlop then ld_perlop else pa_leping.kuup2 endif
    from pa_leping left outer join pa_isik on pa_leping.lepnr = pa_isik.lepnr
                   left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                   left outer join pa_tasu on pa_isik.lepnr=pa_tasu.lepnr and pa_isik.yksusnr=pa_tasu.yksusnr
    where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
          "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
          "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
          (pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and
          (pa_yksus.statnr = a_statnr or a_statnr = 0) and
          pa_leping.kuup1<=ld_perlop and (pa_leping.kuup2 is null or pa_leping.kuup2>=ld_peralg) and
          (pa_leping.id_koht=1 or pa_leping.id_koht=4) and
          pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu and pa_tasu.summa>0;
  insert into gl_pa_stat("id",nimi,kood) values (1,'1. TJUD JA TTATUD TUNNID','');
  select property('ProductVersion') into ls_productversion from DUMMY;
  if left(ls_productversion,1) in ('7','8') then
    delete from gl_tr_universal;
    insert into gl_tr_universal("id","id1","id2")
      select distinct max(pa_leping.lepnr),pa_leping.id_koht,pa_leping.asutnr
        from pa_leping left outer join pa_isik on pa_leping.lepnr = pa_isik.lepnr
                       left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr
                       left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                       left outer join pa_tasu on pa_isik.lepnr=pa_tasu.lepnr and pa_isik.yksusnr=pa_tasu.yksusnr
        where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
              "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
              "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
              (pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and
              (pa_yksus.statnr = a_statnr or a_statnr = 0) and
               pa_leping.kuup1<=ld_perlop and (pa_leping.kuup2 is null or pa_leping.kuup2>=ld_perlop) and
              (pa_leping.id_koht=1 or pa_leping.id_koht=4) and
               pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu and pa_tasu.summa>0
        group by pa_leping.id_koht,pa_leping.asutnr;
    insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
        select 2,
               'Tasu teeninud ttajate arv aruandekuul',
               '1',
               count(if gl_tr_universal.id1=1 then gl_tr_universal."id" else null endif) as a_v2,
               count(if gl_tr_universal.id1=4 then gl_tr_universal."id" else null endif) as a_v3,
               a_v2+a_v3
        from gl_tr_universal
        where pa_peat_lapsehp(ld_perlop,gl_tr_universal."id")=0;
  else
    -- tootajate arv
    insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
        select 2,
               'Tasu teeninud ttajate arv aruandekuul',
               '1',
               count(distinct if gl_list.id1=1 then asulist.reg_nr else null endif) as a_v2,
               count(distinct if gl_list.id1=4 then asulist.reg_nr else null endif) as a_v3,
               a_v2+a_v3
        from gl_list left outer join pa_leping on gl_list."id"=pa_leping.lepnr left outer join asulist on pa_leping.asutnr=asulist.asutnr
        where gl_list.kuup2=ld_perlop and pa_peat_lapsehp(ld_perlop,gl_list."id")=0;
  end if;
  -- taandatud taeg
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 3,
             ''Tistajale taandatud keskmine ttajate arv (kahe kmnendkohaga)'',
             ''2'',
             Round(sum(if gl_list.id1=1 then get_kp_arv_toolpuhk_pta(gl_list.kuup1,gl_list.kuup2,gl_list."id")*gl_list.sum1 else 0 endif)/ldc_kpa_kuus_pta,2) as a_v2,
             Round(sum(if gl_list.id1=4 then get_kp_arv_toolpuhk_pta(gl_list.kuup1,gl_list.kuup2,gl_list."id")*gl_list.sum1 else 0 endif)/ldc_kpa_kuus_pta,2) as a_v3,
             a_v2+a_v3
      from gl_list';
  execute immediate ls_insert;
  -- tootatud tunnid
  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 4,'Ttatud tundide arv (tuhandetes tundides kahe kmnendkohaga)','3',
             Round(sum(if gl_list.id1=1 then get_tundi_paevas(gl_list."id",ldc_tpa_kuus)*get_tp_arv_tool(gl_list.kuup1,gl_list.kuup2,gl_list."id") else 0 endif)/1000,2) as a_v2,
             Round(sum(if gl_list.id1=4 then get_tundi_paevas(gl_list."id",ldc_tpa_kuus)*get_tp_arv_tool(gl_list.kuup1,gl_list.kuup2,gl_list."id") else 0 endif)/1000,2) as a_v3,
             a_v2+a_v3
      from gl_list;
  -- vabad kohad
  insert into gl_pa_stat("id",nimi,kood) values (5,'Vabade tasustatud ametikohtade arv','4');



  insert into gl_pa_stat("id",nimi,kood) values (6,'2. TJUKULUD','x');
  insert into gl_pa_stat("id",nimi,kood) values (7,'2.1 BRUTOPALK, euro','x1');
  -- pohitootasu
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 8,
             ''Phittasu koos igakuise regulaarse lisatasu ja preemiaga'',
             ''5'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida in (5,19,20)';
  execute immediate ls_insert;
  -- yletunnitoo
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 9,
             ''Tasu letunnit eest'',
             ''6'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=6';
  execute immediate ls_insert;
  -- ootoo
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 10,
             ''Lisatasu vahetustega, t ja riigiphal ttamise eest'',
             ''7'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=7';
  execute immediate ls_insert;
  -- ebaregulaarne
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 11,
             ''Ebaregulaarsed lisatasud ja preemiad'',
             ''8'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=8';
  execute immediate ls_insert;
  -- mittetootatud aeg
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 12,
             ''Tasu mittettatud aja eest'',
             ''9'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=9';
  execute immediate ls_insert;
  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1) values (13,'Mitterahaline tasu','10',0,0,0);
  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1) values (14,'Tandja maksed ttajate hoiuskeemidesse','11',0,0,0);


  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1) values (15,'2.2 SOTSIAALMAKS KOOS TOETUSTE/HVITISTEGA, euro','x2',0,0,0);
  -- Sotsiaalmaks
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 16,
             ''Sotsiaalmaks'',
             ''12'',
            Round(sum(if gl_list.id1=1 or gl_list.id1=4 then (if pa_taslist.sisse=0 then pa_tasu.sotsmaks else -1*pa_tasu.sotsmaks endif) else 0 endif),0)
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.statrida <> 20';
  execute immediate ls_insert;
  -- Tootuskindlustus
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 17,
             ''Tandja ttuskindlustusmakse'',
             ''13'',
            Round(sum(if gl_list.id1=1 or gl_list.id1=4 then (if pa_taslist.sisse=0 then pa_tasu.tatkmaks else -1*pa_tasu.tatkmaks endif) else 0 endif),0)
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.statrida <> 20';
  execute immediate ls_insert;
  -- Sotsiaalmaksed
  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1) values (18,'Tandja leppekohased ja vabatahtlikud sotsiaalmaksed (sh kindlustus)','14',0,0,0);
  -- Haigusraha
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 19,
             ''Ttajatele makstavad hvitised haigestumise, tnnetuse ja kutsehaiguse korral'',
             ''15'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=15';
  execute immediate ls_insert;
  -- Toetused pensioniks
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 20,
             ''Ttajale makstavad hvitised ja toetused pensionideks ja tervishoiuks'',
             ''16'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=16';
  execute immediate ls_insert;
  -- Toosuhte lopp
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 21,
             ''Ttajale makstavad hvitised tsuhte lpetamisel'',
             ''17'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=17';
  execute immediate ls_insert;
  -- Muud
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 22,
             ''Ttajale makstavad muud hvitised ja toetused'',
             ''18'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=18';
  execute immediate ls_insert;


  -- Toetused tooandjale
  insert into gl_pa_stat("id",nimi,kood) values (23,'3. TOETUSED TANDJALE, euro','x3');
  -- palgatoetus
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 24,
             ''Tandjale makstud palgatoetus (sisaldub phittasus)'',
             ''19'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=19';
  execute immediate ls_insert;
  -- sihtannetus
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 25,
             ''Sihtannetuse arvelt makstud brutotasu oma ttajatele (sisaldub phittasus)'',
             ''20'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.statrida=20';
  execute immediate ls_insert;

  update gl_pa_stat set v1=0 where v1 is null;
  update gl_pa_stat set v2=0 where v2 is null;
  update gl_pa_stat set v3=0 where v3 is null;

END