ALTER PROCEDURE "dba"."pa_arvuta"(in a_lepnr integer, in a_8o smallint default 1)
begin
  -- arvutatava kuu fetch
  declare li_aasta integer;
  declare li_akuu integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_per insensitive cursor for
    select distinct pa_tasu.t_aasta,pa_tasu.t_akuu
      from pa_tasu
      where pa_tasu.lepnr = a_lepnr and pa_tasu.palgaleht is null
      order by pa_tasu.t_aasta asc,pa_tasu.t_akuu asc;
  open c_per;
  per_loop: loop
    fetch next c_per into li_aasta,li_akuu;
    if sqlstate = err_notfound then
      leave per_loop
    end if;
    if li_aasta>2017 then
      call pa_arvuta2018(a_lepnr,li_aasta,li_akuu)
    end if;
  end loop per_loop;
  close c_per
end