CREATE PROCEDURE "DBA"."ls_kogused_update"( in a_orgnr integer,in peralg date,in perlop date)
BEGIN
  declare ll_id integer;
  declare ld_kuup date;
  declare ldc_kogus numeric(15,2);
  declare ll_maksuid integer;
  declare ll_user_code integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_gl_pr_kanne_update dynamic scroll cursor for select "id",kuup,summa+summa_orig,partnr,user_code from gl_pr_kanne_update where summa<>0;
  delete from gl_pr_kanne_import;
  delete from gl_pr_kanne_update;
  insert into gl_pr_kanne_import("id",kuup,summa,summa_orig,partnr,user_code)
    select ls_kogused."id",ls_kogused.kuup,(-1)*ls_kogused.kogus,ls_kogused.kogus,ls_kogused.maksuid,ls_kogused.user_code
      from ls_kogused left outer join ls_maksud on ls_kogused.maksuid=ls_maksud."id" left outer join ls_yksus on ls_maksud.yksusnr=ls_yksus.yksusnr
      where ls_yksus.orgnr=a_orgnr and ls_kogused.kuup>=peralg and ls_kogused.kuup<=perlop and ls_kogused.tulnud='ELIIS kogus';
  insert into gl_pr_kanne_import("id",kuup,summa,summa_orig,partnr,user_code)
    select 0,kuup,summa,0,partnr,user_code
      from gl_pr_kanne;
  insert into gl_pr_kanne_update("id",kuup,summa,summa_orig,partnr,user_code)
    select max("id"),kuup,sum(summa),sum(summa_orig),partnr,max(user_code)
      from gl_pr_kanne_import
      group by kuup,partnr;
  open c_gl_pr_kanne_update;
  gl_pr_kanne_update: loop
    fetch next c_gl_pr_kanne_update into ll_id,ld_kuup,ldc_kogus,ll_maksuid,ll_user_code;
    if sqlstate = err_notfound then -- kui eof
      leave gl_pr_kanne_update
    end if;
    if ll_id=0 then
      insert into ls_kogused(tulnud,kuup,kogus,maksuid,user_code)
        values ('ELIIS kogus',ld_kuup,ldc_kogus,ll_maksuid,ll_user_code)
    else
      if ldc_kogus=0 then
        delete from ls_kogused where "id"=ll_id
      else
        update ls_kogused set kuup=ld_kuup,kogus=ldc_kogus,maksuid=ll_maksuid,user_code=ll_user_code where "id"=ll_id
      end if
    end if
  end loop gl_pr_kanne_update;
  close c_gl_pr_kanne_update;
END