ALTER PROCEDURE "dba"."ls_kogused_update"( in a_orgnr integer,in peralg date,in perlop date, in a_tulnud char(100) )
BEGIN
  declare ll_id integer;
  declare ld_kuup date;
  declare ldc_kogus numeric(19,6);
  declare ldc_nait numeric(19,6);
  declare ll_maksuid integer;
  declare ll_user_code integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_gl_pr_kanne_update dynamic scroll cursor for select "id",kuup,summa+summa_orig,partnr,user_code,summa2 from gl_pr_kanne_update where summa<>0;
  delete from gl_pr_kanne_import;
  delete from gl_pr_kanne_update;
  insert into gl_pr_kanne_import("id",kuup,summa,summa_orig,partnr,user_code,summa2)
    select ls_kogused."id",ls_kogused.kuup,(-1)*ls_kogused.kogus,ls_kogused.kogus,ls_kogused.maksuid,ls_kogused.user_code,ls_kogused.nait
      from ls_kogused left outer join ls_maksud on ls_kogused.maksuid=ls_maksud."id" left outer join ls_yksus on ls_maksud.yksusnr=ls_yksus.yksusnr
      where (ls_yksus.orgnr=a_orgnr or a_orgnr=0) and ls_kogused.kuup>=peralg and ls_kogused.kuup<=perlop and ls_kogused.tulnud=a_tulnud;
  -- ecofleet sarnased read summeerida kokku
  if a_tulnud='ECOFLEET kogus' then
    insert into gl_pr_kanne_import("id",kuup,summa,summa_orig,partnr,user_code,summa2)
      select 0,max(kuup),sum(summa),0,partnr,max(user_code),max(summa2)
        from gl_pr_kanne
        group by partnr
  else
    insert into gl_pr_kanne_import("id",kuup,summa,summa_orig,partnr,user_code,summa2)
      select 0,kuup,summa,0,partnr,user_code,summa2
        from gl_pr_kanne
  end if;
  insert into gl_pr_kanne_update("id",kuup,summa,summa_orig,partnr,user_code,summa2)
    select max("id"),kuup,sum(summa),sum(summa_orig),partnr,max(user_code),max(summa2)
      from gl_pr_kanne_import
      group by kuup,partnr;
  open c_gl_pr_kanne_update;
  gl_pr_kanne_update: loop
    fetch next c_gl_pr_kanne_update into ll_id,ld_kuup,ldc_kogus,ll_maksuid,ll_user_code,ldc_nait;
    if sqlstate = err_notfound then -- kui eof
      leave gl_pr_kanne_update
    end if;
    if ll_id=0 then
      insert into ls_kogused(tulnud,kuup,kogus,maksuid,user_code,nait)
        values (a_tulnud,ld_kuup,ldc_kogus,ll_maksuid,ll_user_code,ldc_nait)
    else
      if ldc_kogus=0 then
        delete from ls_kogused where "id"=ll_id
      else
        update ls_kogused set kuup=ld_kuup,kogus=ldc_kogus,maksuid=ll_maksuid,user_code=ll_user_code,nait=ldc_nait where "id"=ll_id
      end if
    end if
  end loop gl_pr_kanne_update;
  close c_gl_pr_kanne_update;
END