ALTER PROCEDURE "DBA"."kp_set_doknr"(in a_mass smallint)
begin
  declare ls_doknr char(20);
  declare ll_objnr integer;
  declare li_sisse smallint;
  declare li_years integer;
  declare ld_kuup date;
  declare ll_asutnr integer;
  declare ll_saajanr integer;
  declare ls_sarve char(30);
  declare ls_viitnr char(35);
  declare ls_rkviit char(50);
  declare ll_id integer;
  declare ll_kulnr integer;
  declare ll_artnr integer;
  declare ll_objectnr integer;
  declare ll_suundnr integer;
  declare ll_panknr integer;
  declare ll_formaat integer;
  declare li_rkviit_suund smallint;
  declare err_notfound exception for sqlstate value '02000';
  declare c_gl_kp_kanne dynamic scroll cursor for select gl_kp_kanne.id,gl_kp_kanne.kulnr,gl_kp_kanne.artnr,gl_kp_kanne.objectnr,if li_rkviit_suund=1 then gl_kp_kanne.suundnr else null endif,kp_obj.panknr,kp_obj.formaat from gl_kp_kanne left outer join kp_obj on gl_kp_kanne.objnr = kp_obj.objnr;
  select kp_konfm.rkviit_suund into li_rkviit_suund from kp_konfm where kp_konfm.id=1;
  open c_gl_kp_kanne;
  gl_kp_kanne_loop1: loop
    --  loe kanne
    fetch next c_gl_kp_kanne into ll_id,ll_kulnr,ll_artnr,ll_objectnr,ll_suundnr,ll_panknr,ll_formaat;
    if sqlstate = err_notfound then -- kui eof
      leave gl_kp_kanne_loop1
    end if;
    if(ll_formaat = 1 or ll_formaat = 4) and ll_panknr > 0 then
      set ls_rkviit=get_rkviit(ll_kulnr,ll_artnr,ll_objectnr) + if ll_suundnr is null then '' else convert(char(10),ll_suundnr) endif
    else
      set ls_rkviit=null
    end if;
    update gl_kp_kanne set rkviit = ls_rkviit where id = ll_id
  end loop gl_kp_kanne_loop1;
  close c_gl_kp_kanne;
  gl_kp_kanne_loop: loop
    select first gl_kp_kanne.objnr,gl_kp_kanne.sisse,gl_kp_kanne.kuup,gl_kp_kanne.asutnr,gl_kp_kanne.saajanr,gl_kp_kanne.sarve,gl_kp_kanne.viitnr,gl_kp_kanne.rkviit into ll_objnr,li_sisse,ld_kuup,ll_asutnr,ll_saajanr,ls_sarve,ls_viitnr,ls_rkviit from gl_kp_kanne where gl_kp_kanne.doknr is null;
    if sqlstate = err_notfound then -- kui eof
      leave gl_kp_kanne_loop
    end if;
    set li_years=Years(ld_kuup);
    set ls_doknr=get_doknr_kp(li_years,ll_objnr,li_sisse);
    if a_mass = 1 then
      update gl_kp_kanne set gl_kp_kanne.doknr = ls_doknr where gl_kp_kanne.objnr = ll_objnr and gl_kp_kanne.sisse = li_sisse and gl_kp_kanne.kuup = ld_kuup and(gl_kp_kanne.viitnr = ls_viitnr or(gl_kp_kanne.viitnr is null and ls_viitnr is null)) and(gl_kp_kanne.rkviit = ls_rkviit or(gl_kp_kanne.rkviit is null and ls_rkviit is null))
    else
      if ll_saajanr is null then
        update gl_kp_kanne set gl_kp_kanne.doknr = ls_doknr where gl_kp_kanne.objnr = ll_objnr and gl_kp_kanne.sisse = li_sisse and gl_kp_kanne.kuup = ld_kuup and(gl_kp_kanne.asutnr = ll_asutnr or(gl_kp_kanne.asutnr is null and ll_asutnr is null)) and(gl_kp_kanne.sarve = ls_sarve or(gl_kp_kanne.sarve is null and ls_sarve is null)) and(gl_kp_kanne.viitnr = ls_viitnr or(gl_kp_kanne.viitnr is null and ls_viitnr is null)) and(gl_kp_kanne.rkviit = ls_rkviit or(gl_kp_kanne.rkviit is null and ls_rkviit is null))
      else
        update gl_kp_kanne set gl_kp_kanne.doknr = ls_doknr where gl_kp_kanne.objnr = ll_objnr and gl_kp_kanne.sisse = li_sisse and gl_kp_kanne.kuup = ld_kuup and gl_kp_kanne.saajanr = ll_saajanr and(gl_kp_kanne.sarve = ls_sarve or(gl_kp_kanne.sarve is null and ls_sarve is null)) and(gl_kp_kanne.viitnr = ls_viitnr or(gl_kp_kanne.viitnr is null and ls_viitnr is null)) and(gl_kp_kanne.rkviit = ls_rkviit or(gl_kp_kanne.rkviit is null and ls_rkviit is null))
      end if
    end if;
    insert into kp_kanne( kuup,doknr,summa,sisse,alusnr,info,konto,tulnr,kulnr,talnr,artnr,asutnr,tulnud,objnr,objectnr,user_code,viitnr,sarve,panknr,saajanr,osaknr,subjectnr,suundnr,arvenr,arvekuup,alliknr,ravonr,id_maks,meetnr,taotnr,taiendus,summaeek,taskuup,op_id,lisanr,dkdoknimi)
      select gl_kp_kanne.kuup,gl_kp_kanne.doknr,gl_kp_kanne.summa,gl_kp_kanne.sisse,gl_kp_kanne.alusnr,gl_kp_kanne.info,gl_kp_kanne.konto,gl_kp_kanne.tulnr,gl_kp_kanne.kulnr,gl_kp_kanne.talnr,gl_kp_kanne.artnr,gl_kp_kanne.asutnr,gl_kp_kanne.tulnud,gl_kp_kanne.objnr,gl_kp_kanne.objectnr,gl_kp_kanne.user_code,gl_kp_kanne.viitnr,gl_kp_kanne.sarve,gl_kp_kanne.panknr,gl_kp_kanne.saajanr,gl_kp_kanne.osaknr,gl_kp_kanne.subjectnr,gl_kp_kanne.suundnr,gl_kp_kanne.arvenr,gl_kp_kanne.arvekuup,gl_kp_kanne.alliknr,gl_kp_kanne.ravonr,gl_kp_kanne.id_maks,gl_kp_kanne.meetnr,gl_kp_kanne.taotnr,gl_kp_kanne.taiendus,gl_kp_kanne.summaeek,gl_kp_kanne.taskuup,gl_kp_kanne.op_id,gl_kp_kanne.lisanr,gl_kp_kanne.dkdoknimi
        from gl_kp_kanne
        where gl_kp_kanne.doknr is not null;
    delete from gl_kp_kanne where gl_kp_kanne.doknr is not null
  end loop gl_kp_kanne_loop
end