ALTER PROCEDURE "dba"."kp_dok_koond"(in a_id_user integer)
begin
  declare ll_id integer;
  declare ld_kuup date;
  declare ls_kuup char(10);
  declare ll_objnr integer;
  declare ls_objnimi char(50);
  declare li_sisse integer;
  declare ls_doknr char(20);
  declare ldc_summa decimal(15,2);
  declare ll_asutnr integer;
  declare ls_u_masut char(50);
  declare ls_u_aadr char(150);
  declare ls_aadr char(150);
  declare ls_u_regnr char(11);
  declare ls_u_kmkr char(11);
  declare ls_nimi char(101);
  declare ls_pass char(50);
  declare ls_lisa char(50);
  declare ls_koklisa char(250);
  declare ls_regnr char(11);
  declare ll_mpanknr integer;
  declare ls_mpank char(3);
  declare ls_mpanknimi char(50);
  declare ls_mkorresp char(20);
  declare ls_spank char(3);
  declare ls_spanknimi char(50);
  declare ls_marve char(30);
  declare ls_sarve char(30);
  declare ls_viitnr char(35);
  declare ls_liide char(10);
  declare ls_doknrliide char(20);
  declare ll_formaat integer;
  declare ls_arvenr char(200);
  declare ld_arvekuup date;
  declare ls_info char(251);
  declare ls_kokinfo char(250);
  declare ls_taiendus char(200);
  declare ls_rkviit char(50);
  declare ll_kulnr integer;
  declare ll_tulnr integer;
  declare ll_artnr integer;
  declare ll_objectnr integer;
  declare li_mk_eksp_arvekuup smallint;
  declare li_mk_eksp_arvenr smallint;
  declare ll_valnr integer;
  declare ls_valnr1 char(10);
  declare li_mk_eksp_info smallint;
  declare ls_riik_iso char(2);
  declare ls_sbic char(20);
  declare ls_dkdoknimi char(50);
  declare ls_konto char(7);
  declare err_notfound exception for sqlstate value '02000';
  declare c_kp_kanne dynamic scroll cursor for
    select kp_kanne."id",
           kp_kanne.summa,
          (if kp_kanne.saajanr is null then (if kp_kanne.asutnr is null then 0 else kp_kanne.asutnr endif) else kp_kanne.saajanr endif),
           if kp_kanne.sarve is null or ll_mpanknr is null then '' else kp_kanne.sarve endif,
           if kp_kanne.panknr is null then '' else panklist.spank endif,
           if kp_kanne.panknr is null then '' else panklist.spanknimi endif,
           if kp_kanne.panknr is null then '' else panklist.korresp endif,
           if kp_kanne.viitnr is null or ll_mpanknr is null then '' else kp_kanne.viitnr endif,
           if kp_kanne.dkdoknimi is null then 'Arve nr.' else trim(kp_kanne.dkdoknimi) endif,
           if kp_kanne.arvenr is null then '' else trim(kp_kanne.arvenr) endif,
           kp_kanne.arvekuup,
           trim(kp_alus.nimi+' '+kp_kanne."info"),
           kp_kanne.taiendus,
           kp_kanne.kulnr,
           kp_kanne.tulnr,
           kp_kanne.artnr,
           kp_kanne.objectnr
    from kp_kanne left outer join kp_alus on kp_kanne.alusnr = kp_alus.alusnr
                  left outer join panklist on kp_kanne.panknr = panklist.panknr
    where kp_kanne.objnr = ll_objnr and
          kp_kanne.sisse = li_sisse and
          kp_kanne.kuup = ld_kuup and
          kp_kanne.doknr = ls_doknr;
  select t_user.kp_mk_eksp_arvekuup,t_user.kp_mk_eksp_arvenr,t_user.kp_mk_eksp_info into li_mk_eksp_arvekuup,li_mk_eksp_arvenr,li_mk_eksp_info from t_user where t_user.id_user = a_id_user;

  delete from gl_tr_mk;
  gl_1_loop: loop
    select first gl_1."id",gl_1."kuup" into ll_id,ld_kuup from gl_1;
    if sqlstate = err_notfound then -- kui eof
      leave gl_1_loop
    end if;
    set ls_kuup=convert(char(10),ld_kuup,104);
    select if kp_kanne.konto is null then '' else kp_kanne.konto endif,kp_kanne.objnr,kp_kanne.sisse,kp_kanne.doknr,kp_obj.nimi,kp_obj.panknr,if kp_obj.marve is null then '' else trim(kp_obj.marve) endif,if kp_obj.liide is null then '' else kp_obj.liide endif,kp_obj.formaat,get_u_masut(kp_obj.skoop),get_u_regnr(kp_obj.skoop),get_u_aadr(kp_obj.skoop),get_u_kmkr(kp_obj.skoop),kp_obj.valnr into ls_konto,ll_objnr,li_sisse,ls_doknr,ls_objnimi,ll_mpanknr,ls_marve,ls_liide,ll_formaat,ls_u_masut,ls_u_regnr,ls_u_aadr,ls_u_kmkr,ll_valnr from kp_kanne left outer join kp_obj on kp_kanne.objnr = kp_obj.objnr where kp_kanne."id" = ll_id and kp_kanne.kuup = ld_kuup;
    select vallist.tahis into ls_valnr1 from vallist where vallist.valnr=ll_valnr;
    set ls_doknrliide=ls_doknr+ls_liide;
    if ll_mpanknr is null then
      set ls_mpank='';
      set ls_mpanknimi='';
      set ls_mkorresp='';
    else
      select panklist.spank,panklist.spanknimi,trim(panklist.korresp) into ls_mpank,ls_mpanknimi,ls_mkorresp from panklist where panklist.panknr = ll_mpanknr
    end if;
    open c_kp_kanne;
    kp_kanne_loop: loop
      --  loe kassa/panga kanne
      fetch next c_kp_kanne into ll_id,ldc_summa,ll_asutnr,ls_sarve,ls_spank,ls_spanknimi,ls_sbic,ls_viitnr,ls_dkdoknimi,ls_arvenr,ld_arvekuup,ls_info,ls_taiendus,ll_kulnr,ll_tulnr,ll_artnr,ll_objectnr;
      if sqlstate = err_notfound then -- kui eof
        leave kp_kanne_loop
      end if;
      if ll_asutnr > 0 then
        select get_asulist_nimi_dok(asulist.asutnr),trim(asulist.aadr1+' '+asulist.aadr2+' '+asulist.aadr3),asulist.pass,asulist.lisa,asulist.reg_nr,asulist.riik_iso into ls_nimi,ls_aadr,ls_pass,ls_lisa,ls_regnr,ls_riik_iso from asulist where asulist.asutnr = ll_asutnr
      else
        set ls_nimi='';
        set ls_pass='';
        set ls_lisa='';
        set ls_regnr='';
        set ls_riik_iso=''
      end if;
      if(ll_formaat = 1 or ll_formaat = 4) and ll_mpanknr > 0 then
        set ls_rkviit=get_rkviit(ll_kulnr,ll_artnr,ll_objectnr,ll_tulnr)
      else
        set ls_rkviit=''
      end if;
      if not exists(select 1 from gl_tr_mk where gl_tr_mk.objnr = ll_objnr and gl_tr_mk.sisse = li_sisse and gl_tr_mk.dkuup = ld_kuup and gl_tr_mk.doknr = ls_doknr and gl_tr_mk.asutnr = ll_asutnr and gl_tr_mk.sarve = ls_sarve and gl_tr_mk.viitnr = ls_viitnr and gl_tr_mk.rkviit = ls_rkviit) then
        insert into gl_tr_mk( "id",objnr,sisse,dkuup,kuup,doknr,summa,summa2,u_masut,u_regnr,u_aadr,u_kmkr,marve,mpank,mpanknimi,asutnr,nimi,sarve,spank,spanknimi,sbic,viitnr,doknrliide,aadr,pass,lisa,regnr,rkviit,objnimi,"info",taiendus,valnr,valnr1,mkorresp,riik_iso,konto)
                     values( ll_id,ll_objnr,li_sisse,ld_kuup,ls_kuup,ls_doknr,0,0,ls_u_masut,ls_u_regnr,ls_u_aadr,ls_u_kmkr,ls_marve,ls_mpank,ls_mpanknimi,ll_asutnr,ls_nimi,ls_sarve,ls_spank,ls_spanknimi,ls_sbic,ls_viitnr,ls_doknrliide,ls_aadr,ls_pass,ls_lisa,ls_regnr,ls_rkviit,ls_objnimi,'','',ll_valnr,ls_valnr1,ls_mkorresp,ls_riik_iso,ls_konto)
      end if;
      select gl_tr_mk."info",gl_tr_mk.taiendus into ls_kokinfo,ls_koklisa from gl_tr_mk where gl_tr_mk.objnr = ll_objnr and gl_tr_mk.sisse = li_sisse and gl_tr_mk.dkuup = ld_kuup and gl_tr_mk.doknr = ls_doknr and gl_tr_mk.asutnr = ll_asutnr and gl_tr_mk.sarve = ls_sarve and gl_tr_mk.viitnr = ls_viitnr and gl_tr_mk.rkviit = ls_rkviit;
      if Length(ls_arvenr) > 0 and li_mk_eksp_arvenr=1 then
        set ls_arvenr=Trim(ls_dkdoknimi+' '+ls_arvenr);
        if ld_arvekuup is not null and li_mk_eksp_arvekuup=1 then
          set ls_arvenr=ls_arvenr+' '+convert(char(10),ld_arvekuup,104)
        end if;
        if locate(ls_kokinfo,ls_arvenr,1) = 0 then
          set ls_kokinfo=Left(Trim(ls_kokinfo+' '+ls_arvenr),250)
        end if
      else
        set ls_arvenr = ''
      end if;
      if Length(ls_info) > 0 and (ll_mpanknr is null or li_mk_eksp_info = 1 or (Length(ls_arvenr) = 0 and Length(ls_viitnr) = 0)) then
        if locate(ls_kokinfo,ls_info,1) = 0 then
          set ls_kokinfo=Left(Trim(ls_kokinfo+' '+ls_info),250)
        end if
      end if;
      if Length(ls_taiendus) > 0 then
        if locate(ls_koklisa,ls_taiendus,1) = 0 then
          set ls_koklisa=Left(Trim(ls_koklisa+' '+ls_taiendus),200)
        end if
      end if;
      update gl_tr_mk set gl_tr_mk.summa = gl_tr_mk.summa+ldc_summa,gl_tr_mk."info" = ls_kokinfo,gl_tr_mk.taiendus = ls_koklisa where gl_tr_mk.objnr = ll_objnr and gl_tr_mk.sisse = li_sisse and gl_tr_mk.dkuup = ld_kuup and gl_tr_mk.doknr = ls_doknr and gl_tr_mk.asutnr = ll_asutnr and gl_tr_mk.sarve = ls_sarve and gl_tr_mk.viitnr = ls_viitnr and gl_tr_mk.rkviit = ls_rkviit;
      delete from gl_1 where gl_1."id" = ll_id and gl_1.kuup = ld_kuup
    end loop kp_kanne_loop;
    close c_kp_kanne;
  end loop gl_1_loop
end