CREATE FUNCTION "DBA"."get_json_value"( a_field long varchar, a_row long varchar)
RETURNS long varchar
BEGIN
  declare ls_value long varchar;
  declare ll_row_length integer;
  declare ll_pos1 integer;
  declare ll_pos2 integer;
  set ll_row_length=Length(a_row);
  if ll_row_length>0 then
    set ll_pos1=locate(a_row,a_field,1);
    if ll_pos1>0 then
      set ll_pos2=locate(a_row,':',ll_pos1);
      if ll_pos2>ll_pos1 then
        set ls_value='';
        set ll_pos2=ll_pos2+1;
        while substring(a_row,ll_pos2,1) not in (',','}') and ll_pos2<=ll_row_length loop
          set ls_value=ls_value+substring(a_row,ll_pos2,1);
          set ll_pos2=ll_pos2+1;
        end loop;
        set ls_value=trim(ls_value);
        if left(ls_value,1)='"' then
          set ls_value=substring(ls_value,2)
        end if;
        if right(ls_value,1)='"' then
          set ls_value=left(ls_value,length(ls_value)-1)
        end if;
      end if;
    end if;
  end if;
  if ls_value is null then
    set ls_value=''
  end if;
  RETURN ls_value;
END