CREATE PROCEDURE "DBA"."ea_sumsisu"( in a_skoop integer, in a_komb integer, in a_valkutu char(1), in a_sisid integer, in a_colxx char(5) )
BEGIN
  declare li_id_lkd integer;
  declare li_id_col integer;
  declare li_colnr integer;
  declare li_i integer;
  declare li_tyyp integer;
  declare ld_peralg date;
  declare ld_perlop date;
  declare li_varaasta smallint;
  declare li_varper smallint;
  declare li_eaobj smallint;
  declare ls_meet char(16);
  declare ls_kulu_obj char(16);
  declare ls_teg_ala char(16);
  declare ls_kulu_liik char(16);
  declare ls_tulu_liik char(16);
  declare ls_projekt char(16);
  declare ls_osakond char(16);
  declare ls_subjekt char(16);
  declare ls_teg_suund char(16);
  declare ls_taot char(16);
  declare err_notfound exception for sqlstate value '02000';
  declare c_col dynamic scroll cursor for
    select id,tyyp,peralg,perlop,varaasta,varper,eaobj
      from ea_lkd_col left outer join ea_col_def on ea_lkd_col.id_col=ea_col_def.id
      where ea_lkd_col.id_lkd=li_id_lkd
      order by ea_col_def.jrknr;

  delete from gl_kp_kanne;
  if a_skoop is null then
    set a_skoop=0
  end if;
  if Length(a_colxx)=5 then
    set li_colnr=convert(integer,right(a_colxx,2))
  else
    set li_colnr=0
  end if;
  if li_colnr>0 and (a_valkutu='k' or a_valkutu='t') then
    select first
        if meet is null then '' else Trim(meet) endif,
        if kulu_obj is null then '' else Trim(kulu_obj) endif,
        if teg_ala is null then '' else Trim(teg_ala) endif,
        if kulu_liik is null then '' else Trim(kulu_liik) endif,
        if tulu_liik is null then '' else Trim(tulu_liik) endif,
        if projekt is null then '' else Trim(projekt) endif,
        if osakond is null then '' else Trim(osakond) endif,
        if subjekt is null then '' else Trim(subjekt) endif,
        if teg_suund is null then '' else Trim(teg_suund) endif,
        if taot is null then '' else Trim(taot) endif
      into ls_meet,ls_kulu_obj,ls_teg_ala,ls_kulu_liik,ls_tulu_liik,ls_projekt,ls_osakond,ls_subjekt,ls_teg_suund,ls_taot
      from gl_ea_rida where gl_ea_rida.id=a_sisid;
    if Length(ls_meet)>0 or Length(ls_kulu_obj)>0 or Length(ls_teg_ala)>0 or Length(ls_kulu_liik)>0 or Length(ls_tulu_liik)>0 or Length(ls_projekt)>0 or Length(ls_osakond)>0 or Length(ls_subjekt)>0 or Length(ls_teg_suund)>0 or Length(ls_taot)>0 then
      select ea_komb.id_lkd into li_id_lkd from ea_komb where ea_komb.id=a_komb;
      set li_i=0;
      open c_col;
      col_loop: while li_i<li_colnr loop
        fetch next c_col into li_id_col,li_tyyp,ld_peralg,ld_perlop,li_varaasta,li_varper,li_eaobj;
        if sqlstate = err_notfound then -- kui eof
          leave col_loop
        end if;
        set li_i=li_i+1;
      end loop col_loop;
      close c_col;
      if li_tyyp=1 or li_tyyp=2 or li_tyyp=3 then
        case li_tyyp
        when 1 then
          set li_tyyp=1
        when 2 then
          insert into gl_kp_kanne(id,kuup,doknr,summa,arvekuup,arvenr,asutnr,info,konto,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr)
            select kp_kanne.id,kp_kanne.kuup,kp_kanne.doknr,kp_kanne.summa,kp_kanne.arvekuup,kp_kanne.arvenr,kp_kanne.asutnr,Left(Trim(kp_alus.nimi+' '+kp_kanne.info),200),kp_kanne.konto,kp_kanne.meetnr,kp_kanne.kulnr,kp_kanne.talnr,kp_kanne.artnr,kp_kanne.tulnr,kp_kanne.objectnr,kp_kanne.osaknr,kp_kanne.subjectnr,kp_kanne.suundnr,kp_kanne.taotnr
              from kp_kanne left outer join kp_obj on kp_kanne.objnr=kp_obj.objnr
                            left outer join kp_alus on kp_kanne.alusnr=kp_alus.alusnr
                            left outer join meetlist on kp_kanne.meetnr=meetlist.meetnr
                            left outer join kullist on kp_kanne.kulnr=kullist.kulnr
                            left outer join tallist on kp_kanne.talnr=tallist.talnr
                            left outer join artlist on kp_kanne.artnr=artlist.artnr
                            left outer join tullist on kp_kanne.tulnr=tullist.tulnr
                            left outer join objlist on kp_kanne.objectnr=objlist.objectnr
                            left outer join osaklist on kp_kanne.osaknr=osaklist.osaknr
                            left outer join sublist on kp_kanne.subjectnr=sublist.subjectnr
                            left outer join suundlist on kp_kanne.suundnr=suundlist.suundnr
                            left outer join taotlist on kp_kanne.taotnr=taotlist.taotnr
              where kp_obj.eaobj=1 and
                    (kp_obj.skoop=a_skoop or a_skoop=0) and
                    kp_kanne.artnr is not null and
                    kp_kanne.kuup>=ld_peralg and kp_kanne.kuup<=ld_perlop and
                    (kp_kanne.meetnr is null or Left(meetlist.meet,Length(ls_meet))=ls_meet) and
                    (kp_kanne.kulnr is null or Left(kullist.ptk,Length(ls_kulu_obj))=ls_kulu_obj) and
                    (kp_kanne.talnr is null or Left(tallist.osa,Length(ls_teg_ala))=ls_teg_ala) and
                    (kp_kanne.artnr is null or Left(artlist.art,Length(ls_kulu_liik))=ls_kulu_liik) and
                    (kp_kanne.tulnr is null or Left(tullist.osa,Length(ls_tulu_liik))=ls_tulu_liik) and
                    (kp_kanne.objectnr is null or Left(objlist.object,Length(ls_projekt))=ls_projekt) and
                    (kp_kanne.osaknr is null or Left(osaklist.osak,Length(ls_osakond))=ls_osakond) and
                    (kp_kanne.subjectnr is null or Left(sublist.subject,Length(ls_subjekt))=ls_subjekt) and
                    (kp_kanne.suundnr is null or Left(suundlist.suund,Length(ls_teg_suund))=ls_teg_suund) and
                    (kp_kanne.taotnr is null or Left(taotlist.taot,Length(ls_taot))=ls_taot)
        when 3 then
          set li_tyyp=3
        end case;
      end if
    end if
  end if
END