ALTER PROCEDURE "DBA"."dk_viivis_leping"( in a_perlop date, in a_id integer)
BEGIN
  declare ldc_volg numeric(20,6);
  declare ldc_saldo numeric(20,6);
  declare ldc_laek numeric(20,6);
  declare ldc_osamaks numeric(20,6);
  declare ldc_viivis numeric(20,6);
  declare ldc_panga_intress numeric(20,6);
  declare li_pvi integer;
  declare ld_arvekuup date;
  declare ls_arvenr char(20);
  declare ll_asutnr integer;
  declare li_id_graafik integer;
  declare ld_akuup_viivis date;
  declare ld_lkuup_viivis date;
  declare ld_akuup_graafik date;
  declare ld_lkuup_graafik date;
  declare ld_kuup date;
  declare err_notfound exception for sqlstate value '02000';
  declare c_dk_graafik dynamic scroll cursor for select "dk_graafik"."id", if "dk_graafik"."akuup" < ld_akuup_viivis then ld_akuup_viivis else "dk_graafik"."akuup" endif, if "dk_graafik"."lkuup" is null or "dk_graafik"."lkuup" > ld_lkuup_viivis then ld_lkuup_viivis else "dk_graafik"."lkuup" endif from "dk_graafik" where ("dk_graafik"."arvekuup"=ld_arvekuup and "dk_graafik"."arvenr"=ls_arvenr and "dk_graafik"."asutnr"=ll_asutnr) and "dk_graafik"."akuup" <= ld_lkuup_viivis and ("dk_graafik"."lkuup" >= ld_akuup_viivis or "dk_graafik"."lkuup" is null) order by "dk_graafik"."akuup" ASC;
  declare c_dk_graafik_rida dynamic scroll cursor for select "dk_graafik_rida"."kuup", "dk_graafik_rida"."osamaks" from "dk_graafik_rida" where ("dk_graafik_rida"."id_graafik"=li_id_graafik and "dk_graafik_rida"."kuup">=ld_akuup_graafik and "dk_graafik_rida"."kuup"<=ld_lkuup_graafik) and "dk_graafik_rida"."osamaks"<>0 order by "dk_graafik_rida"."kuup" ASC;
  declare c_gl_dk_viivis dynamic scroll cursor for select gl_dk_viivis.kuup, gl_dk_viivis.arvest, gl_dk_viivis.laek from gl_dk_viivis order by gl_dk_viivis.kuup;
  delete from gl_dk_viivis;
  select dk_graafik.arvekuup, dk_graafik.arvenr, dk_graafik.asutnr, dk_graafik.akuup, a_perlop, panga_intress into ld_arvekuup,ls_arvenr,ll_asutnr,ld_akuup_viivis,ld_lkuup_viivis,ldc_panga_intress from "dk_graafik" where "dk_graafik"."id" = a_id;
  select sum(if "dk_kanne"."sisse"=1 then ("dk_kanne"."summa"+"dk_kanne"."summa2") else -1*("dk_kanne"."summa"+"dk_kanne"."summa2") endif) into ldc_volg
    from "dk_kanne" left outer join "dk_obj" on "dk_kanne"."objnr"="dk_obj"."objnr"
    where "dk_kanne"."arvekuup"=ld_arvekuup and "dk_kanne"."arvenr"=ls_arvenr and "dk_kanne"."asutnr"=ll_asutnr and Left(dk_obj.djkonto,6) in ('103240','103000');
  if ldc_volg is null then
    set ldc_volg=0
  end if;
  if ldc_panga_intress is null then
    set ldc_panga_intress=0
  end if;
  set ldc_volg=ldc_volg-ldc_panga_intress;
  select sum(if "kp_kanne"."sisse"=1 then "kp_kanne"."summa" else -1*("kp_kanne"."summa") endif) into ldc_laek
    from "kp_kanne"
    where ("kp_kanne"."arvekuup"=ld_arvekuup and "kp_kanne"."arvenr"=ls_arvenr and "kp_kanne"."asutnr"=ll_asutnr) AND Left(kp_kanne.konto,6) in ('103240','103000') and "kp_kanne"."kuup"<ld_akuup_viivis;
  if ldc_laek is null then
    set ldc_laek=0
  end if;
  if ldc_volg > ldc_laek then
    -- laekumised viivise arvestuse perioodi jooksul
    insert into gl_dk_viivis ( id,kuup,laek)
      select a_id,kp_kanne.kuup,sum(if kp_kanne.sisse=1 then kp_kanne.summa else -1*(kp_kanne.summa) endif)
       from kp_kanne
       where (kp_kanne.arvekuup=ld_arvekuup and kp_kanne.arvenr=ls_arvenr and kp_kanne.asutnr=ll_asutnr) and Left(kp_kanne.konto,6) in ('103240','103000') and "kp_kanne"."kuup">=ld_akuup_viivis and "kp_kanne"."kuup"<=ld_lkuup_viivis
       group by "kp_kanne"."kuup"
	   order by "kp_kanne"."kuup" asc;
    -- volg viivise arvestuse alguse perioodiks
    if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_akuup_viivis) then
      update gl_dk_viivis set arvest=ldc_volg where gl_dk_viivis.kuup=ld_akuup_viivis
    else
      insert into gl_dk_viivis (id,kuup,arvest,laek) values (a_id,ld_akuup_viivis,ldc_volg,ldc_laek)
    end if;
    -- graafiku osamaksed
    open c_dk_graafik;
    dk_graafik_loop: loop
      fetch next c_dk_graafik into li_id_graafik, ld_akuup_graafik, ld_lkuup_graafik;
      if sqlstate = err_notfound then -- kui eof
        leave dk_graafik_loop
      end if;
      select sum(dk_graafik_rida.osamaks) into ldc_saldo from dk_graafik_rida where dk_graafik_rida.id_graafik=li_id_graafik and dk_graafik_rida.kuup < ld_akuup_graafik;
      if ldc_saldo is null then
        set ldc_saldo=0
      end if;
      if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_akuup_graafik) then
        update gl_dk_viivis set arvest=arvest + ldc_saldo - ldc_volg + ldc_laek where gl_dk_viivis.kuup=ld_akuup_graafik
      else
        insert into gl_dk_viivis (id,kuup,arvest) values (a_id,ld_akuup_graafik,ldc_saldo-ldc_volg+ldc_laek)
      end if;
      open c_dk_graafik_rida;
      dk_graafik_rida_loop: loop
        fetch next c_dk_graafik_rida into ld_kuup, ldc_osamaks;
        if sqlstate = err_notfound then -- kui eof
          leave dk_graafik_rida_loop
        end if;
        set ldc_saldo = ldc_saldo + ldc_osamaks;
        if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_kuup) then
          update gl_dk_viivis set arvest=arvest+ldc_osamaks where gl_dk_viivis.kuup=ld_kuup
        else
          insert into gl_dk_viivis (id,kuup,arvest) values (a_id,ld_kuup,ldc_osamaks)
        end if;
      end loop dk_graafik_rida_loop;
      close c_dk_graafik_rida;
      if ld_lkuup_graafik < ld_lkuup_viivis then
        if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_lkuup_graafik) then
          update gl_dk_viivis set arvest=arvest + ldc_volg - ldc_saldo - ldc_laek where gl_dk_viivis.kuup=ld_lkuup_graafik
        else
          insert into gl_dk_viivis (id,kuup,arvest) values (a_id,ld_lkuup_graafik,ldc_volg - ldc_saldo - ldc_laek)
        end if
      end if
    end loop dk_graafik_loop;
    close c_dk_graafik;
    -- viivise arvutamine
    set ldc_volg = 0;
    open c_gl_dk_viivis;
    gl_dk_viivis_loop: loop
      fetch next c_gl_dk_viivis into ld_kuup, ldc_osamaks, ldc_laek;
      if sqlstate = err_notfound then -- kui eof
        leave gl_dk_viivis_loop
      end if;
      set ldc_viivis = 0;
      set li_pvi = DateDiff(day, ld_akuup_viivis, ld_kuup)+1;
      set ld_akuup_viivis = ld_kuup+1;
      if li_pvi>0 and ldc_volg>0 then
        set ldc_viivis = Round(ldc_volg * li_pvi * 8 / 36500,2);
      end if;
      update gl_dk_viivis set volg=ldc_volg, pvi=li_pvi, viivis=ldc_viivis where kuup=ld_kuup;
      set ldc_volg = ldc_volg + ldc_osamaks - ldc_laek;
    end loop gl_dk_viivis_loop;
    close c_gl_dk_viivis;
    if ldc_volg > 0 then
      set ldc_viivis = 0;
      set li_pvi = DateDiff(day, ld_akuup_viivis, ld_lkuup_viivis)+1;
      if li_pvi > 0 then
        set ldc_viivis = Round(ldc_volg * li_pvi * 8 / 36500,2);
      end if;
      if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_lkuup_viivis) then
        update gl_dk_viivis set pvi=pvi+li_pvi, viivis=viivis+ldc_viivis where kuup=ld_lkuup_viivis
      else
        insert into gl_dk_viivis (id,kuup,volg,pvi,viivis) values (a_id,ld_lkuup_viivis,ldc_volg,li_pvi,ldc_viivis)
      end if
    end if;
  end if
END