ALTER PROCEDURE "dba"."dk_set_doknr2"()
BEGIN
  declare ll_id integer;
  declare li_aasta integer;
  declare li_doknr integer;
  declare ls_doknr char(20);
  declare li_spank smallint;
  declare li_skoop integer;
  declare ls_nimi char(101);
  declare ll_objnr integer;
  declare li_objnr integer;
  declare ll_asutnr integer;
  declare ld_arvekuup date;
  declare ls_arvenr char(20);
  declare ll_saajanr integer;
  declare ll_panknr integer;
  declare ls_sarve char(30);
  declare ls_laps_info1 char(100);
  declare ll_old_asutnr integer;
  declare ld_old_arvekuup date;
  declare ls_old_arvenr char(20);
  declare ll_old_saajanr integer;
  declare ll_old_panknr integer;
  declare ls_old_sarve char(30);
  declare ls_old_laps_info1 char(100);
  declare li_yksarve integer;
  declare li_yksinfo1 integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_obj dynamic scroll cursor for
    select distinct objnr,Years(arvekuup) from gl_dk_kanne;
  declare c_kanne dynamic scroll cursor for
    select gl_dk_kanne."id",
           get_asulist_nimi_quick(gl_dk_kanne.asutnr) as asulist_nimi,
           gl_dk_kanne.arvekuup,
           if gl_dk_kanne.arvenr is null then '' else gl_dk_kanne.arvenr endif as gl_arvenr,
           if gl_dk_kanne.asutnr is null then 0 else gl_dk_kanne.asutnr endif as gl_asutnr,
           if gl_dk_kanne.saajanr is null then 0 else gl_dk_kanne.saajanr endif as gl_saajanr,
           if gl_dk_kanne.panknr is null then 0 else gl_dk_kanne.panknr endif as gl_panknr,
           if gl_dk_kanne.sarve is null then '' else gl_dk_kanne.sarve endif as gl_sarve,
           if gl_dk_kanne.ls_laps_info1 is null then '' else gl_dk_kanne.ls_laps_info1 endif as gl_ls_laps_info1
      from gl_dk_kanne where objnr=ll_objnr and Years(arvekuup)=li_aasta
      order by asulist_nimi asc, gl_asutnr asc, arvekuup asc, gl_arvenr asc, gl_saajanr asc, gl_panknr asc, gl_sarve asc, gl_ls_laps_info1 asc;

  -- loe parameetrid
  select dk_konfm.yld_yksarve,dk_konfm.yld_yksinfo1 into li_yksarve,li_yksinfo1 from dk_konfm where dk_konfm."id"=1;

  -- lukusta tabel
  lock table "dk_kanne_dok" in exclusive mode;

  -- tsykkel le imporditavate kannete
  open c_obj;
  obj_loop: loop
    fetch next c_obj into ll_objnr,li_aasta;
    if sqlstate = err_notfound then -- kui eof
      leave obj_loop
    end if;

    -- algvaartused
    set li_doknr=0;
    set ls_doknr='';
    set ll_old_asutnr=0;
    set ld_old_arvekuup=ymd(2000,1,1);
    set ls_old_arvenr='';
    set ll_old_saajanr=0;
    set ll_old_panknr=0;
    set ls_old_sarve='';
    set ls_old_laps_info1='';

    -- otsi esimene dokumendi number
    set li_objnr=ll_objnr;
    select dk_obj.mindoknrs,dk_obj.spank,dk_obj.skoop into li_doknr,li_spank,li_skoop from dk_obj where dk_obj.objnr=ll_objnr;
    if li_doknr = 0 then
      set li_objnr=0;
      set li_doknr=1;
      select if dk_konfm.dok_auku=1 then 0 else li_skoop endif into li_skoop from dk_konfm where dk_konfm."id"=1;
    end if;
    select first if dk_kanne_dok.doknr is null or li_doknr>dk_kanne_dok.doknr then li_doknr else dk_kanne_dok.doknr endif into li_doknr from dk_kanne_dok where dk_kanne_dok.aasta=li_aasta and dk_kanne_dok.skoop=li_skoop and dk_kanne_dok.objnr=li_objnr and dk_kanne_dok.sisse=li_spank;
    -- tsyklis lisatakse yks juurde
    set li_doknr=li_doknr-1;

    -- tsykkel le imporditavate kannete
    open c_kanne;
    kanne_loop: loop
      fetch next c_kanne into ll_id,ls_nimi,ld_arvekuup,ls_arvenr,ll_asutnr,ll_saajanr,ll_panknr,ls_sarve,ls_laps_info1;
      if sqlstate = err_notfound then -- kui eof
        leave kanne_loop
      end if;

      -- kui ei ole sama dokumendi rida
      if not (ld_arvekuup=ld_old_arvekuup and ls_arvenr=ls_old_arvenr and ll_asutnr=ll_old_asutnr and (ll_saajanr=ll_old_saajanr or li_yksarve=1) and ll_panknr=ll_old_panknr and ls_sarve=ls_old_sarve and (ls_laps_info1=ls_old_laps_info1 OR li_yksinfo1=1)) then
        -- arvuta uus dokumendi number
        set li_doknr=li_doknr+1;
        -- kontrolli kannetes
        while exists(select 1 from dk_kanne left outer join dk_obj on dk_kanne.objnr = dk_obj.objnr where(Years(dk_kanne.arvekuup)=li_aasta) and(dk_kanne.doknr=trim(str(li_doknr,20))) and((dk_kanne.objnr=li_objnr) or ((li_objnr=0 and (dk_obj.skoop=li_skoop or li_skoop=0)) and dk_obj.spank=li_spank and dk_obj.mindoknrs=0 ))) loop
          set li_doknr=li_doknr+1;
        end loop;
        set ls_doknr=trim(str(li_doknr,20));
        -- fikseeri jooksev rida, mis muutub eelmiseks reaks
        set ll_old_asutnr=ll_asutnr;
        set ld_old_arvekuup=ld_arvekuup;
        set ls_old_arvenr=ls_arvenr;
        set ll_old_saajanr=ll_saajanr;
        set ll_old_panknr=ll_panknr;
        set ls_old_sarve=ls_sarve;
        set ls_old_laps_info1=ls_laps_info1;
      end if;

      -- muuda dokumendi number
      update gl_dk_kanne
        set gl_dk_kanne.doknr=ls_doknr,
            gl_dk_kanne.arvenr=if gl_dk_kanne.arvenr is null or Trim(gl_dk_kanne.arvenr)='' then ls_doknr else gl_dk_kanne.arvenr endif
        where gl_dk_kanne."id"=ll_id

    end loop kanne_loop;
    close c_kanne;

    -- fikseeri viimane dokumendi number nimekirjas
    if li_doknr>0 then
      if exists(select 1 from dk_kanne_dok where dk_kanne_dok.aasta=li_aasta and dk_kanne_dok.skoop=li_skoop and dk_kanne_dok.objnr=li_objnr and dk_kanne_dok.sisse=li_spank) then
        update dk_kanne_dok set doknr=li_doknr where dk_kanne_dok.aasta=li_aasta and dk_kanne_dok.skoop=li_skoop and dk_kanne_dok.objnr=li_objnr and dk_kanne_dok.sisse=li_spank
      else
        insert into dk_kanne_dok (aasta,skoop,objnr,sisse,doknr) values (li_aasta,li_skoop,li_objnr,li_spank,li_doknr)
      end if;
    end if;

--  insert kannetesse
    insert into dk_kanne( objnr,tulnud,sisse,kuup,summa,doknr,"info",konto,asutnr,kulnr,artnr,tulnr,alusnr,objectnr,user_code,arvekuup,arvenr,taskuup,viitnr,sarve,panknr,kogus,yhiknr,hind,kbnr,summa2,taiendus,saajanr,osaknr,subjectnr,suundnr,talnr,alliknr,ravonr,partnr,summa3,summa4,id_maks,meetnr,taotnr,id_earve,id_autoviivis,invoiceid,servicenr,crekuup,crenr,lisanr)
      select gl_dk_kanne.objnr,gl_dk_kanne.tulnud,gl_dk_kanne.sisse,gl_dk_kanne.kuup,gl_dk_kanne.summa,gl_dk_kanne.doknr,gl_dk_kanne."info",gl_dk_kanne.konto,gl_dk_kanne.asutnr,gl_dk_kanne.kulnr,gl_dk_kanne.artnr,gl_dk_kanne.tulnr,gl_dk_kanne.alusnr,gl_dk_kanne.objectnr,gl_dk_kanne.user_code,gl_dk_kanne.arvekuup,gl_dk_kanne.arvenr,gl_dk_kanne.taskuup,gl_dk_kanne.viitnr,gl_dk_kanne.sarve,gl_dk_kanne.panknr,gl_dk_kanne.kogus,gl_dk_kanne.yhiknr,gl_dk_kanne.hind,gl_dk_kanne.kbnr,gl_dk_kanne.summa2,gl_dk_kanne.taiendus,gl_dk_kanne.saajanr,gl_dk_kanne.osaknr,gl_dk_kanne.subjectnr,gl_dk_kanne.suundnr,gl_dk_kanne.talnr,gl_dk_kanne.alliknr,gl_dk_kanne.ravonr,gl_dk_kanne.partnr,gl_dk_kanne.summa3,gl_dk_kanne.summa4,gl_dk_kanne.id_maks,gl_dk_kanne.meetnr,gl_dk_kanne.taotnr,gl_dk_kanne.id_earve,gl_dk_kanne.id_autoviivis,gl_dk_kanne.invoiceid,gl_dk_kanne.servicenr,gl_dk_kanne.crekuup,gl_dk_kanne.crenr,lisanr
        from gl_dk_kanne where doknr is not null and objnr=ll_objnr and years(arvekuup)=li_aasta order by doknr asc,gl_dk_kanne.tulnud asc;

  end loop obj_loop;
  close c_obj;

END