CREATE PROCEDURE "DBA"."dk_korrig_2"(in id_obj integer,in a_perlop date)
begin
  declare ll_count1 integer;
  declare ll_count2 integer;
  declare ll_skoop integer;
  declare li_spank smallint;
  declare ls_dk_kontod char(7);
  declare ll_id integer;
  declare ll_id_ettemaks integer;
  declare ll_id_volg integer;
  declare ll_asutnr integer;
  declare ll_aasta integer;
  declare ls_arvenr char(20);
  declare ld_arvekuup date;
  declare ls_arvenr_volg char(20);
  declare ld_arvekuup_volg date;
  declare ldc_vahe decimal(15,2);
  declare ldc_ettemaks decimal(15,2);
  declare ldc_volg decimal(15,2);
  declare ldc_summa decimal(15,2);
  declare ls_text long varchar;
  declare err_notfound exception for sqlstate value '02000';
  declare c_ettemaks1 dynamic scroll cursor for
    select "id",gl_dk_arvetas.asutnr,gl_dk_arvetas.arvenr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.makssumma
      from gl_dk_arvetas
      where arvesumma=0
      order by gl_dk_arvetas.arvekuup asc;
  declare c_volg1 dynamic scroll cursor for
    select "id",arvenr,arvekuup,arvesumma-makssumma
      from gl_dk_arvetas2007
      where asutnr=ll_asutnr
      order by arvekuup asc;
  declare c_kanne dynamic scroll cursor for
    select "id",aasta,summa
      from gl_dk_kanne
      order by kuup asc;
  select djkonto,spank,skoop into ls_dk_kontod,li_spank,ll_skoop from dk_obj where objnr=id_obj;
  delete from gl_dk_arvetas;
  delete from gl_logi;
  -- arveldused
  insert into gl_logi("text")
    values ('Periood:  '+convert(char(20),a_perlop,104));
  insert into gl_logi("text")
    select 'Valdkond: '+"skoobid"."nimi"+'   Arvelduste objekt: '+"dk_obj"."nimi"+'   Konto: '+"dk_obj"."djkonto" from dk_obj key join skoobid where objnr=id_obj;
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,arvesumma)
    select dk_kanne.asutnr,
           if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
           if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
           sum(if dk_kanne.sisse=li_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif)
      from dk_kanne key left outer join dk_obj
      where dk_kanne.objnr=id_obj and dk_kanne.asutnr>0 and dk_kanne.kuup<=a_perlop
      group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
  -- kassa/pank
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,makssumma)
    select kp_kanne.asutnr,
           if kp_kanne.arvenr is null then '' else kp_kanne.arvenr endif as kp_kanne_arvenr,
           if kp_kanne.arvekuup is null then ymd(2000,1,1) else kp_kanne.arvekuup endif as kp_kanne_arvekuup,
           sum(if kp_kanne.sisse=li_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif)
      from kp_kanne key left outer join kp_obj
      where kp_obj.skoop=ll_skoop and kp_kanne.konto=ls_dk_kontod and kp_kanne.asutnr>0 and kp_kanne.kuup<=a_perlop
      group by kp_kanne.asutnr,kp_kanne_arvekuup,kp_kanne_arvenr;
  -- muuda puuduvad vaartused
  update gl_dk_arvetas set arvenr='nullus' where arvenr is null;
  update gl_dk_arvetas set arvekuup=ymd(2000,1,1) where arvekuup is null;
  update gl_dk_arvetas set arvesumma=0 where arvesumma is null;
  update gl_dk_arvetas set makssumma=0 where makssumma is null;
  delete from gl_dk_arvetas where arvesumma=0 and makssumma=0;
  select count(if arvesumma<>0 then 1 else null endif),count(if makssumma<>0 then 1 else null endif) into ll_count1,ll_count2 from gl_dk_arvetas;
  insert into gl_logi("text")
    values('Arveid: '+convert(char(10),ll_count1)+'   Tasumisi: '+convert(char(10),ll_count2));
  -- summeri yks arve yheks reaks
  delete from gl_dk_arvetas2007;
  insert into gl_dk_arvetas2007( asutnr,arvekuup,arvenr,arvesumma,makssumma)
    select gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr,sum(gl_dk_arvetas.arvesumma),sum(gl_dk_arvetas.makssumma)
     from gl_dk_arvetas
     group by gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr;
  -- kustuta null arved
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 where gl_dk_arvetas2007.arvesumma=gl_dk_arvetas2007.makssumma;
  -- ettemaksud tabelisse gl_dk_arvetas
  delete gl_dk_arvetas;
  insert into gl_dk_arvetas(asutnr,arvenr,arvekuup,arvesumma,makssumma)
    select gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvenr,gl_dk_arvetas2007.arvekuup,gl_dk_arvetas2007.arvesumma,gl_dk_arvetas2007.makssumma
      from gl_dk_arvetas2007
      where gl_dk_arvetas2007.arvesumma<gl_dk_arvetas2007.makssumma;
  -- volad tabelisse gl_dk_arvetas2007
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 where gl_dk_arvetas2007.arvesumma<gl_dk_arvetas2007.makssumma;
  select count() into ll_count1 from gl_dk_arvetas2007;
  select count() into ll_count2 from gl_dk_arvetas;
  insert into gl_logi("text")
    values('Vlas arveid: '+convert(char(10),ll_count1)+'   Ettemakstud arveid: '+convert(char(10),ll_count2));
  -- tsykkel yle ettemaksude, kui arve summa puudub
  open c_ettemaks1;
  ettemaks1_loop: loop
    fetch next c_ettemaks1 into ll_id_ettemaks,ll_asutnr,ls_arvenr,ld_arvekuup,ldc_ettemaks;
    if sqlstate = err_notfound then -- kui eof
      leave ettemaks1_loop
    end if;
    insert into gl_logi("text")
      values('Mramata laekumine: arve '+convert(char(20),ld_arvekuup,104)+' nr '+ls_arvenr+' asutus/isik '+get_asulist_nimi_quick(ll_asutnr)+' summa '+convert(char(20),ldc_ettemaks));
    -- kassa/panga kanded summadega, mis peavad andma ldc_ettemaks
    delete from gl_dk_kanne;
    insert into gl_dk_kanne("id",aasta,kuup,summa)
      select kp_kanne."id",kp_kanne.aasta,kp_kanne.kuup,if kp_kanne.sisse=li_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif
      from kp_kanne key left outer join kp_obj
      where kp_obj.skoop=ll_skoop and
            kp_kanne.konto=ls_dk_kontod and
            kp_kanne.asutnr=ll_asutnr and
            kp_kanne.kuup<=a_perlop and
           (kp_kanne.arvenr=ls_arvenr or ls_arvenr='nullus' and kp_kanne.arvenr is null) and
           (kp_kanne.arvekuup=ld_arvekuup or ld_arvekuup=ymd(2000,1,1) and kp_kanne.arvekuup is null);
    select sum(summa) into ldc_summa from gl_dk_kanne;
    if ldc_summa<>ldc_ettemaks then
      insert into gl_logi("text")
        values('Ettemaks '+convert(char(20),ldc_ettemaks)+' ei vrdu kannete summa '+convert(char(20),ldc_summa));
      set ldc_ettemaks=0
    end if;
    -- tsykkel kuni ettemaks kahaneb nullini
    ettemaks2_loop: while ldc_ettemaks>0 loop
      -- tsykkel yle volgade
      open c_volg1;
      volg1_loop: loop
        fetch next c_volg1 into ll_id_volg,ls_arvenr_volg,ld_arvekuup_volg,ldc_volg;
        if sqlstate = err_notfound then -- kui eof
          set ldc_ettemaks=0;
          leave volg1_loop
        end if;
        if ldc_ettemaks<ldc_volg then
          set ldc_vahe=ldc_ettemaks;
          set ldc_ettemaks=0;
          -- kui ettemaks on viksem vola summa, siis volga vahendada
          update gl_dk_arvetas2007 set makssumma=makssumma+ldc_vahe where id=ll_id_volg
        else
          set ldc_vahe=ldc_volg;
          set ldc_ettemaks=ldc_ettemaks-ldc_volg;
          -- kui ettemaks on suurem vordne, siis volg kustutada
          delete gl_dk_arvetas2007 where id=ll_id_volg
        end if;
        -- tsykkel kuni vahe kahaneb nullini
        vahe_loop: while ldc_vahe>0 loop
          -- tsykkel yle kassa/panga kannete
          open c_kanne;
          kanne_loop: loop
            fetch next c_kanne into ll_id,ll_aasta,ldc_summa;
            if sqlstate = err_notfound then -- kui eof
              set ldc_vahe=0;
              leave kanne_loop
            end if;
            if ldc_vahe<ldc_summa then
              set ldc_vahe=0;
            else
              set ldc_vahe=ldc_vahe-ldc_summa
            end if;
            -- muuda kassa/panga kande arve number ja kuupaev
            update kp_kanne set arvenr=ls_arvenr_volg,arvekuup=ld_arvekuup_volg where "id"=ll_id and aasta=ll_aasta;
            insert into gl_logi("text")
              values('Muudetud kanne nr. '+convert(char(20),ll_id)+' aasta '+convert(char(20),ll_aasta)+'   Arve '+convert(char(20),ld_arvekuup_volg,104)+' nr '+ls_arvenr_volg);
            -- kustuta ajutine kassa/panga kanne, mis on kasutatud
            delete from gl_dk_kanne where "id"=ll_id and aasta=ll_aasta;
            if ldc_vahe=0 then
              leave kanne_loop
            end if;
          end loop kanne_loop;
          close c_kanne;
        end loop vahe_loop;
        if ldc_ettemaks=0 then
          leave volg1_loop
        end if;
      end loop volg1_loop;
      close c_volg1;
    end loop ettemaks2_loop;
  end loop ettemaks1_loop;
  close c_ettemaks1;
end