ALTER PROCEDURE "DBA"."dk_korrig_2"(in id_obj integer,in a_perlop date)
begin
  declare ll_count1 integer;
  declare ll_count2 integer;
  declare ll_skoop integer;
  declare ll_objnr integer;
  declare li_spank smallint;
  declare ls_dk_kontod char(7);
  declare ll_id integer;
  declare ll_id_ettemaks integer;
  declare ll_id_volg integer;
  declare ll_asutnr integer;
  declare ll_aasta integer;
  declare ls_arvenr char(20);
  declare ld_arvekuup date;
  declare ls_arvenr_volg char(20);
  declare ld_arvekuup_volg date;
  declare ls_doknr char(20);
  declare ld_kuup date;
  declare ld_taskuup date;
  declare li_sisse smallint;
  declare li_pole_kp smallint;
  declare li_pole_dk smallint;
  declare ldc_vahe decimal(15,2);
  declare ldc_ettemaks decimal(15,2);
  declare ldc_volg decimal(15,2);
  declare ldc_summa decimal(15,2);
  declare ldc_summa2 decimal(15,2);
  declare ldc_vahe_summa decimal(15,2);
  declare ldc_vahe_summa2 decimal(15,2);
  declare ls_text long varchar;
  declare err_notfound exception for sqlstate value '02000';
  declare c_ettemaks1 dynamic scroll cursor for
    select "id",gl_dk_arvetas.asutnr,gl_dk_arvetas.arvenr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.makssumma-gl_dk_arvetas.arvesumma
      from gl_dk_arvetas
      where arvesumma<>0
      order by gl_dk_arvetas.arvekuup asc;
  declare c_volg1 dynamic scroll cursor for
    select "id",arvenr,arvekuup,arvesumma-makssumma
      from gl_dk_arvetas2007
      where asutnr=ll_asutnr
      order by arvekuup asc;
  declare c_kp_kanne dynamic scroll cursor for
    select "id","objnr",sisse,kuup,doknr,summa
      from gl_kp_kanne
      order by kuup asc;
  declare c_dk_kanne dynamic scroll cursor for
    select "id","objnr",sisse,kuup,doknr,summa,summa2
      from gl_dk_kanne
      order by kuup asc;
  select djkonto,spank,skoop into ls_dk_kontod,li_spank,ll_skoop from dk_obj where objnr=id_obj;
  set ld_taskuup=ymd(2010,1,1);
  delete from gl_dk_arvetas;
  delete from gl_logi;
  -- arveldused
  insert into gl_logi("text")
    values ('Periood:  '+convert(char(20),a_perlop,104));
  insert into gl_logi("text")
    select 'Valdkond: '+"skoobid"."nimi"+'   Arvelduste objekt: '+"dk_obj"."nimi"+'   Konto: '+"dk_obj"."djkonto" from dk_obj key join skoobid where objnr=id_obj;
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,arvesumma)
    select dk_kanne.asutnr,
           if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
           if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
           sum(if dk_kanne.sisse=li_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif)
      from dk_kanne key left outer join dk_obj
      where dk_kanne.objnr=id_obj and dk_kanne.asutnr>0 and dk_kanne.kuup<=a_perlop
      group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
  -- kassa/pank
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,makssumma)
    select kp_kanne.asutnr,
           if kp_kanne.arvenr is null then '' else kp_kanne.arvenr endif as kp_kanne_arvenr,
           if kp_kanne.arvekuup is null then ymd(2000,1,1) else kp_kanne.arvekuup endif as kp_kanne_arvekuup,
           sum(if kp_kanne.sisse=li_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif)
      from kp_kanne key left outer join kp_obj
      where kp_obj.skoop=ll_skoop and kp_kanne.konto=ls_dk_kontod and kp_kanne.asutnr>0 and kp_kanne.kuup<=a_perlop
      group by kp_kanne.asutnr,kp_kanne_arvekuup,kp_kanne_arvenr;
  -- muuda puuduvad vaartused
  update gl_dk_arvetas set arvenr='puudub' where arvenr is null;
  update gl_dk_arvetas set arvenr='puudub' where arvenr='';
  update gl_dk_arvetas set arvekuup=ymd(2000,1,1) where arvekuup is null;
  update gl_dk_arvetas set arvesumma=0 where arvesumma is null;
  update gl_dk_arvetas set makssumma=0 where makssumma is null;
  delete from gl_dk_arvetas where arvesumma=0 and makssumma=0;
  select count(if arvesumma<>0 then 1 else null endif),count(if makssumma<>0 then 1 else null endif) into ll_count1,ll_count2 from gl_dk_arvetas;
  insert into gl_logi("text")
    values('Arveid: '+convert(char(10),ll_count1)+'   Tasumisi: '+convert(char(10),ll_count2));
  -- summeri yks arve yheks reaks
  delete from gl_dk_arvetas2007;
  insert into gl_dk_arvetas2007( asutnr,arvekuup,arvenr,arvesumma,makssumma)
    select gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr,sum(gl_dk_arvetas.arvesumma),sum(gl_dk_arvetas.makssumma)
     from gl_dk_arvetas
     group by gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr;
  -- kustuta null arved
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 where gl_dk_arvetas2007.arvesumma=gl_dk_arvetas2007.makssumma;
  -- ettemaksud tabelisse gl_dk_arvetas
  delete gl_dk_arvetas;
  insert into gl_dk_arvetas(asutnr,arvenr,arvekuup,arvesumma,makssumma)
    select gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvenr,gl_dk_arvetas2007.arvekuup,gl_dk_arvetas2007.arvesumma,gl_dk_arvetas2007.makssumma
      from gl_dk_arvetas2007
      where gl_dk_arvetas2007.arvesumma<gl_dk_arvetas2007.makssumma;
  -- volad tabelisse gl_dk_arvetas2007
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 where gl_dk_arvetas2007.arvesumma<gl_dk_arvetas2007.makssumma;
  select count() into ll_count1 from gl_dk_arvetas2007;
  select count() into ll_count2 from gl_dk_arvetas;
  insert into gl_logi("text")
    values('Vlas arveid: '+convert(char(10),ll_count1)+'   Ettemakstud arveid: '+convert(char(10),ll_count2));
  -- tsykkel yle ettemaksude makssumma-arvesumma
  open c_ettemaks1;
  ettemaks1_loop: loop
    fetch next c_ettemaks1 into ll_id_ettemaks,ll_asutnr,ls_arvenr,ld_arvekuup,ldc_ettemaks;
    if sqlstate = err_notfound then -- kui eof
      leave ettemaks1_loop
    end if;
    insert into gl_logi("text")
      values('Ettemakstud arve '+convert(char(20),ld_arvekuup,104)+' nr. '+ls_arvenr+'   Asutus/isik '+get_asulist_nimi_quick(ll_asutnr)+'   Summa: '+convert(char(20),ldc_ettemaks));
--message 'Ettemakstud arve '+convert(char(20),ld_arvekuup,104)+' nr '+ls_arvenr+' asutus/isik '+get_asulist_nimi_quick(ll_asutnr)+' summa '+convert(char(20),ldc_ettemaks);
    -- kassa/panga kanded summadega, mis moodustavad ldc_ettemaks
    delete from gl_kp_kanne;
    insert into gl_kp_kanne("objnr",sisse,kuup,doknr,summa)
      select kp_kanne."objnr",kp_kanne.sisse,kp_kanne.kuup,kp_kanne.doknr,sum(if kp_kanne.sisse=li_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif)
      from kp_kanne key left outer join kp_obj
      where kp_obj.skoop=ll_skoop and
            kp_kanne.konto=ls_dk_kontod and
            kp_kanne.asutnr=ll_asutnr and
            kp_kanne.kuup<=a_perlop and
           (kp_kanne.arvenr=ls_arvenr) and
           (kp_kanne.arvekuup=ld_arvekuup)
      group by kp_kanne."objnr",kp_kanne.sisse,kp_kanne.kuup,kp_kanne.doknr;
    delete from gl_kp_kanne where summa=0;
    -- arvelduste kanded summadega, mis moodustavad ldc_ettemaks
    delete from gl_dk_kanne;
    insert into gl_dk_kanne("objnr",sisse,kuup,doknr,summa,summa2)
      select dk_kanne."objnr",dk_kanne.sisse,dk_kanne.kuup,dk_kanne.doknr,sum(if dk_kanne.sisse=li_spank then -1*(dk_kanne.summa) else dk_kanne.summa endif),sum(if dk_kanne.sisse=li_spank then -1*(dk_kanne.summa2) else dk_kanne.summa2 endif)
      from dk_kanne key left outer join dk_obj
      where dk_obj.skoop=ll_skoop and
            dk_kanne.objnr=id_obj and
            dk_kanne.asutnr=ll_asutnr and
            dk_kanne.kuup<=a_perlop and
           (dk_kanne.arvenr=ls_arvenr) and
           (dk_kanne.arvekuup=ld_arvekuup)
      group by dk_kanne."objnr",dk_kanne.sisse,dk_kanne.kuup,dk_kanne.doknr;
    delete from gl_dk_kanne where summa=0;
    -- tsykkel kuni ettemaks kahaneb nullini
    ettemaks2_loop: while ldc_ettemaks>0 loop
      -- tsykkel yle volgade kuni jatkub ettemaksu
      open c_volg1;
      volg1_loop: loop
        fetch next c_volg1 into ll_id_volg,ls_arvenr_volg,ld_arvekuup_volg,ldc_volg;
        if sqlstate = err_notfound then -- kui ei ole volas arveid
          set ldc_ettemaks=0;
          leave volg1_loop
        end if;
--message ls_arvenr_volg;
        -- kui ettemaks on viksem, kui vola summa, siis volga vahendada
        if ldc_ettemaks<ldc_volg then
          set ldc_vahe=ldc_ettemaks;
          -- kogu ettemaks laheb vola katteks
          set ldc_ettemaks=0;
          update gl_dk_arvetas2007 set makssumma=makssumma+ldc_vahe where "id"=ll_id_volg
        else
          set ldc_vahe=ldc_volg;
          -- ettemaksust jagub jargmise vola katteks
          set ldc_ettemaks=ldc_ettemaks-ldc_volg;
          -- kui ettemaks on suurem vordne, siis volg kustutada
          delete gl_dk_arvetas2007 where id=ll_id_volg
        end if;
--message 'vahe 1';
--message ldc_vahe;
        -- tsykkel kuni vahe kahaneb nullini volas arve suhtes
        vahe_loop: while ldc_vahe>0 loop
          -- tsykkel yle kassa/panga kannete, mis moodustavad ettemaksu
          set li_pole_kp=0;
          set li_pole_dk=0;
          open c_kp_kanne;
          kp_kanne_loop: loop
            fetch next c_kp_kanne into ll_id,ll_objnr,li_sisse,ld_kuup,ls_doknr,ldc_summa;
            if sqlstate = err_notfound then -- kui ei ole kandeid
              set li_pole_dk=1;
              leave kp_kanne_loop
            end if;
--message 'kassapank';
--message ll_id;
--message 'summa';
--message ldc_summa;
            -- tsykkel kuni vahe kahaneb nullini kassa/panga kannete suhtes
            vahe2_loop: while ldc_vahe>0 and ldc_summa<>0 loop
              if ldc_summa<0 then
                if ldc_vahe<abs(ldc_summa) then
--message 'miinus viksem';
                  set ldc_vahe_summa=ldc_vahe;
                  -- kogu vahe laheb korrigeerimisele
                  set ldc_vahe=0;
                -- kui vahe on vaiksem, kui kande summa, siis kande summat vahendada
                  update gl_kp_kanne set summa=summa-ldc_vahe_summa where "id"=ll_id;
                  set ldc_summa=ldc_summa-ldc_vahe_summa;
                else
--message 'miinus suurem vrdne';
                  set ldc_vahe_summa=-1*ldc_summa;
                  set ldc_vahe=ldc_vahe+ldc_summa;
                  -- kui vahe on suurem kande summa, siis kanne kustutada
                  delete from gl_kp_kanne where "id"=ll_id;
                  set ldc_summa=0;
                end if;
              else
                if ldc_vahe<ldc_summa then
--message 'pluss viksem';
                  set ldc_vahe_summa=ldc_vahe;
                  -- kogu vahe laheb korrigeerimisele
                  set ldc_vahe=0;
                  -- kui vahe on vaiksem, kui kande summa, siis kande summat vahendada
                  update gl_kp_kanne set summa=summa-ldc_vahe_summa where "id"=ll_id;
                  set ldc_summa=ldc_summa-ldc_vahe_summa;
                else
--message 'pluss suurem vrdne';
                  set ldc_vahe_summa=ldc_summa;
                  set ldc_vahe=ldc_vahe-ldc_summa;
                  -- kui vahe on suurem vordne kande summa, siis kanne kustutada
                  delete from gl_kp_kanne where "id"=ll_id;
                  set ldc_summa=0;
                end if;
              end if;
--message 'vahe 2';
--message ldc_vahe;
--message 'vahe summa';
--message ldc_vahe_summa;
              -- lisa kassa/panga kanne miinusega ettemaksu arve number ja kuupaev
              insert into kp_kanne(objnr,sisse,kuup,doknr,summa,arvekuup,arvenr,asutnr,konto,user_code,tulnud)
                values(ll_objnr,0,ld_kuup,ls_doknr,ldc_vahe_summa,ld_arvekuup,ls_arvenr,ll_asutnr,ls_dk_kontod,32767,'dk_korrig_2_2020');
              -- lisa kassa/panga kanne plussiga volas arve number ja kuupaev
              insert into kp_kanne(objnr,sisse,kuup,doknr,summa,arvekuup,arvenr,asutnr,konto,user_code,tulnud)
                values(ll_objnr,1,ld_kuup,ls_doknr,ldc_vahe_summa,ld_arvekuup_volg,ls_arvenr_volg,ll_asutnr,ls_dk_kontod,32767,'dk_korrig_2_2020');
              insert into gl_logi("text")
                values('Lisatud Kassa/panga kanded kuupevaga '+convert(char(20),ld_kuup,104)+' dok.nr. '+ls_doknr+'   Varasem ettemakstud arve '+convert(char(20),ld_arvekuup,104)+' nr. '+ls_arvenr+'   Varasem vlas arve '+convert(char(20),ld_arvekuup_volg,104)+' nr. '+ls_arvenr_volg);
            end loop vahe2_loop;
            if ldc_vahe=0 then
              leave kp_kanne_loop
            end if;
          end loop kp_kanne_loop;
          close c_kp_kanne;
          -- tsykkel yle arvelduste kannete, mis moodustavad ettemaksu
          open c_dk_kanne;
          dk_kanne_loop: loop
            fetch next c_dk_kanne into ll_id,ll_objnr,li_sisse,ld_kuup,ls_doknr,ldc_summa,ldc_summa2;
            if sqlstate = err_notfound then -- kui ei ole kandeid
              set li_pole_dk=1;
              leave dk_kanne_loop
            end if;
--message 'arveldused';
--message ll_id;
--message 'summa';
--message ldc_summa+ldc_summa2;
--message 'vahe';
--message ldc_vahe;
            -- tsykkel kuni vahe kahaneb nullini arvelduste kannete suhtes
            vahe3_loop: while ldc_vahe>0 and ldc_summa+ldc_summa2<>0 loop
              -- kui kande summa miinusega
              if ldc_summa+ldc_summa2<0 then
                -- kui vahe on vaiksem, kui kande summa, siis kande summat vahendada
                if ldc_vahe<abs(ldc_summa+ldc_summa2) then
--message 'miinus viksem';
                  set ldc_vahe_summa=Round(ldc_vahe/(ldc_summa+ldc_summa2)*ldc_summa,2);
                  set ldc_vahe_summa2=ldc_vahe-ldc_vahe_summa;
                  -- kogu vahe laheb korrigeerimisele
                  set ldc_vahe=0;
                  update gl_dk_kanne set summa=summa-ldc_vahe_summa,summa2=summa2-ldc_vahe_summa2 where "id"=ll_id;
                  set ldc_summa=ldc_summa-ldc_vahe_summa;
                  set ldc_summa2=ldc_summa2-ldc_vahe_summa2;
                else
--message 'miinus suurem';
                  set ldc_vahe_summa=-1*(ldc_summa);
                  set ldc_vahe_summa2=-1*(ldc_summa2);
                  set ldc_vahe=ldc_vahe+ldc_summa+ldc_summa2;
                  -- kui vahe on suurem kande summa, siis kanne kustutada
                  delete from gl_dk_kanne where "id"=ll_id;
                  set ldc_summa=0;
                  set ldc_summa2=0;
                end if;
              else
                -- kui vahe on vaiksem, kui kande summa, siis kande summat vahendada
                if ldc_vahe<ldc_summa+ldc_summa2 then
--message 'pluss viksem';
                  set ldc_vahe_summa=Round(ldc_vahe/(ldc_summa+ldc_summa2)*ldc_summa,2);
                  set ldc_vahe_summa2=ldc_vahe-ldc_vahe_summa;
                  -- kogu vahe laheb korrigeerimisele
                  set ldc_vahe=0;
                  update gl_dk_kanne set summa=summa-ldc_vahe_summa,summa2=summa2-ldc_vahe_summa2 where "id"=ll_id;
                  set ldc_summa=ldc_summa-ldc_vahe_summa;
                  set ldc_summa2=ldc_summa2-ldc_vahe_summa2;
                else
--message 'pluss suurem';
                  set ldc_vahe_summa=ldc_summa;
                  set ldc_vahe_summa2=ldc_summa2;
                  set ldc_vahe=ldc_vahe-(ldc_summa+ldc_summa2);
                  -- kui vahe on suurem vordne kande summa, siis kanne kustutada
                  delete from gl_dk_kanne where "id"=ll_id;
                  set ldc_summa=0;
                  set ldc_summa2=0;
                end if;
              end if;
--message 'vahe 3';
--message ldc_vahe;
--message 'ldc_vahe_summa';
--message ldc_vahe_summa+ldc_vahe_summa2;
              -- lisa arvelduste kanne miinusega ettemaksu arve number ja kuupaev
              insert into dk_kanne(objnr,sisse,kuup,taskuup,doknr,summa,summa2,arvekuup,arvenr,asutnr,user_code,tulnud)
                values(ll_objnr,1,ld_kuup,ld_taskuup,ls_doknr,ldc_vahe_summa,ldc_vahe_summa2,ld_arvekuup,ls_arvenr,ll_asutnr,32767,'dk_korrig_2_2020');
              -- lisa arvelduste kanne plussiga volas arve number ja kuupaev
              insert into dk_kanne(objnr,sisse,kuup,taskuup,doknr,summa,summa2,arvekuup,arvenr,asutnr,user_code,tulnud)
                values(ll_objnr,0,ld_kuup,ld_taskuup,ls_doknr,ldc_vahe_summa,ldc_vahe_summa2,ld_arvekuup_volg,ls_arvenr_volg,ll_asutnr,32767,'dk_korrig_2_2020');
              insert into gl_logi("text")
                values('Lisatud Arvelduste kanded kuupevaga '+convert(char(20),ld_kuup,104)+' dok.nr. '+ls_doknr+'   Varasem ettemakstud arve '+convert(char(20),ld_arvekuup,104)+' nr. '+ls_arvenr+'   Varasem vlas arve '+convert(char(20),ld_arvekuup_volg,104)+' nr. '+ls_arvenr_volg);
            end loop vahe3_loop;
            -- uus osa kui pole kandeid
            if li_pole_kp=1 and li_pole_dk=1 then
              set ldc_ettemaks=0;
              set ldc_vahe=0;
            end if;
            if ldc_vahe=0 then
              leave dk_kanne_loop
            end if;
          end loop dk_kanne_loop;
          close c_dk_kanne;
        end loop vahe_loop;
        if ldc_ettemaks=0 then
          leave volg1_loop
        end if;
      end loop volg1_loop;
      close c_volg1;
    end loop ettemaks2_loop;
  end loop ettemaks1_loop;
  close c_ettemaks1;
end