ALTER PROCEDURE "dba"."dk_import_delete"( in ai_objnr integer, in ad_peralg date, in ad_perlop date, in as_tulnud char(100), in ai_yksusnr integer default 0)
BEGIN
  declare ll_id integer;
  declare ll_doknr integer;
  declare ll_aasta integer;
  declare li_spank smallint;
  declare ll_skoop integer;
  declare ll_objnr integer;
  declare ls_yksusnr char(20);
  declare ls_productversion char(100);
  declare err_notfound exception for sqlstate value '02000';
  declare c_dk_kanne dynamic scroll cursor for select distinct dk_kanne.aasta from dk_kanne where "dk_kanne"."objnr"=ai_objnr and "dk_kanne"."arvekuup"=ad_perlop and Left("dk_kanne"."tulnud",5)=as_tulnud and locate("dk_kanne"."tulnud",ls_yksusnr)>0;
  if ai_yksusnr=0 then
    set ls_yksusnr=as_tulnud
  else
    set ls_yksusnr='yksusnr '+ trim(convert(char(20),ai_yksusnr)) + ';'
  end if;
  if as_tulnud='Arved' then
    open c_dk_kanne;
    dk_kanne_loop: loop
      fetch next c_dk_kanne into ll_aasta;
      if sqlstate = err_notfound then -- kui eof
        leave dk_kanne_loop
      end if;
      set ll_id=0;
      select min("dk_kanne"."id") into ll_id from "dk_kanne" where "dk_kanne"."objnr"=ai_objnr and "dk_kanne"."arvekuup"=ad_perlop and Left("dk_kanne"."tulnud",5)=as_tulnud and locate("dk_kanne"."tulnud",ls_yksusnr)>0 and "dk_kanne"."aasta"=ll_aasta;
      if ll_id>0 then
        update "dk_kanne_id" set "id"=ll_id where aasta=ll_aasta;
      end if;
    end loop dk_kanne_loop;
    close c_dk_kanne;
    set ll_aasta=years(ad_perlop);
    select dk_obj.mindoknrs,dk_obj.spank,dk_obj.skoop into ll_doknr,li_spank,ll_skoop from dk_obj where dk_obj.objnr=ai_objnr;
    set ll_objnr=ai_objnr;
    if ll_doknr = 0 then
      set ll_objnr=0;
      select if li_spank=1 then if dk_konfm.mindoknrv is null or dk_konfm.mindoknrv<=0 then 1 else dk_konfm.mindoknrv endif else if dk_konfm.mindoknrs is null or dk_konfm.mindoknrs<=0 then 1 else dk_konfm.mindoknrs endif endif, if dk_konfm.dok_auku=1 then 0 else ll_skoop endif into ll_doknr,ll_skoop from dk_konfm where dk_konfm."id"=1;
    end if;
    if ll_doknr>0 then
      set ll_doknr=0;
      select property('ProductVersion') into ls_productversion from DUMMY;
      if left(ls_productversion,1) in ('7','8') then
        select min(cast(doknr as integer)) into ll_doknr from "dk_kanne" where "dk_kanne"."objnr"=ai_objnr and "dk_kanne"."arvekuup"=ad_perlop and Left("dk_kanne"."tulnud",5)=as_tulnud and locate("dk_kanne"."tulnud",ls_yksusnr)>0;
      else
        select min(cast(doknr as integer)) into ll_doknr from "dk_kanne" where "dk_kanne"."objnr"=ai_objnr and "dk_kanne"."arvekuup"=ad_perlop and Left("dk_kanne"."tulnud",5)=as_tulnud and locate("dk_kanne"."tulnud",ls_yksusnr)>0 and isnumeric(doknr)=1;
      end if;
      if ll_doknr>0 then
        update "dk_kanne_dok" set "doknr"=if "doknr"<ll_doknr then "doknr" else ll_doknr endif where dk_kanne_dok.aasta=ll_aasta and dk_kanne_dok.skoop=ll_skoop and dk_kanne_dok.objnr=ll_objnr and dk_kanne_dok.sisse=li_spank;
      end if;
    end if;
    delete from "dk_kanne" where ("dk_kanne"."arvekuup"=ad_perlop) AND ("dk_kanne"."objnr"=ai_objnr) AND Left("dk_kanne"."tulnud",5)=as_tulnud and locate("dk_kanne"."tulnud",ls_yksusnr)>0;
  end if
END