ALTER PROCEDURE "DBA"."dk_graafik_rida"( in a_id_graafik integer )
BEGIN
  declare ld_arvekuup date;
  declare ls_arvenr char(20);
  declare li_asutnr integer;
  declare ld_akuup date;
  declare ld_maksekuup date;
  declare ld_lkuup date;
  declare li_kuudearv integer;
  declare li_intervall integer;
  declare li_valemnr integer;
  declare li_jrknr integer;
  declare ldc_volg numeric(20,6);
  declare ldc_summa numeric(20,6);
  declare ldc_intmaar numeric(30,16);
  declare ldc_const numeric(30,16);
  declare ldc_osamaks numeric(20,6);
  declare ldc_jaak numeric(20,6);
  declare ldc_lisaint numeric(20,6);
  declare ldc_pangaint numeric(20,6);
  if a_id_graafik > 0 then
    set li_jrknr=0;
    select arvekuup,arvenr,asutnr,akuup,maksekuup,lkuup,kuudearv,intmaar,intervall,valemnr into ld_arvekuup,ls_arvenr,li_asutnr,ld_akuup,ld_maksekuup,ld_lkuup,li_kuudearv,ldc_intmaar,li_intervall,li_valemnr from dk_graafik where dk_graafik."id"=a_id_graafik;
    delete from dk_graafik_rida where id_graafik=a_id_graafik;
    select sum(if dk_kanne.sisse=1 then (dk_kanne.summa+dk_kanne.summa2) else -1*(dk_kanne.summa+dk_kanne.summa2) endif) into ldc_volg
        from dk_kanne left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
        where dk_obj.viivis=0 and dk_obj.spank=0 and dk_kanne.arvekuup=ld_arvekuup and dk_kanne.arvenr=ls_arvenr and dk_kanne.asutnr=li_asutnr and Left(dk_obj.djkonto,6) in ('103240','103000');
    if ldc_volg is null then
      set ldc_volg=0
    end if;
    select sum(if kp_kanne.sisse=1 then kp_kanne.summa else -1*(kp_kanne.summa) endif) into ldc_summa
      from kp_kanne
      where (kp_kanne.arvekuup=ld_arvekuup and kp_kanne.arvenr=ls_arvenr and kp_kanne.asutnr=li_asutnr) and Left(kp_kanne.konto,6) in ('103240','103000') and kp_kanne.kuup<ld_akuup;
    if not(ldc_summa is null or ldc_summa=0) then
      set ldc_volg=ldc_volg-ldc_summa;
    end if;
    select sum(if dk_kanne.sisse=1 then (dk_kanne.summa+dk_kanne.summa2) else -1*(dk_kanne.summa+dk_kanne.summa2) endif) into ldc_pangaint
        from dk_kanne left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
        where dk_obj.viivis=0 and dk_obj.spank=0 and dk_kanne.arvekuup=ld_arvekuup and dk_kanne.arvenr=ls_arvenr and dk_kanne.asutnr=li_asutnr and dk_obj.djkonto='103690' and left(dk_kanne.konto,1)='7';
    if ldc_pangaint is null then
      set ldc_pangaint=0
    end if;
    select sum(if kp_kanne.sisse=1 then kp_kanne.summa else -1*(kp_kanne.summa) endif) into ldc_summa
      from kp_kanne
      where (kp_kanne.arvekuup=ld_arvekuup and kp_kanne.arvenr=ls_arvenr and kp_kanne.asutnr=li_asutnr) and kp_kanne.konto='103690' and kp_kanne.kuup<ld_akuup;
    if not(ldc_summa is null or ldc_summa=0) then
        set ldc_pangaint=ldc_pangaint-ldc_summa;
    end if;
    if ldc_volg > 0 then
      insert into dk_graafik_rida(id_graafik,jrknr,kuup,volg,intress) values (a_id_graafik,li_jrknr,ld_akuup,ldc_volg,ldc_pangaint);
      case li_valemnr
        when 1 then
          set ldc_intmaar=ldc_intmaar/1200;
          set ldc_const=1-power(1+ldc_intmaar,-1*li_kuudearv);
          if ldc_const=0 then
            set ldc_summa=Round(ldc_volg/li_kuudearv,2);
          else
            set ldc_summa=Round((ldc_volg*ldc_intmaar)/ldc_const,2);
          end if;
          set ldc_lisaint=Round(ldc_volg*(dateadd(day,-30,ld_maksekuup)-ld_akuup)*ldc_intmaar/30,2);
          set ld_akuup=ld_maksekuup;
          while li_jrknr<li_kuudearv and (ld_lkuup is null or ld_akuup<=ld_lkuup) loop
            set li_jrknr=li_jrknr+1;
            set ldc_const=1-power(1+ldc_intmaar,-1*(li_kuudearv-li_jrknr));
            if ldc_const=0 then
              set ldc_jaak=Round(ldc_summa*(li_kuudearv-li_jrknr),2);
            else
              set ldc_jaak=Round((ldc_summa*ldc_const)/ldc_intmaar,2);
            end if;
            set ldc_osamaks=ldc_volg-ldc_jaak;
            insert into dk_graafik_rida(id_graafik,jrknr,kuup,volg,osamaks,intress) values (a_id_graafik,li_jrknr,ld_akuup,ldc_volg,ldc_osamaks,if ldc_intmaar=0 then 0 else ldc_summa-ldc_osamaks+ldc_lisaint endif);
            set ldc_lisaint=0;
            set ld_akuup=dateadd(month,li_jrknr,ld_maksekuup);
            set ldc_volg=ldc_jaak;
          end loop
        when 2 then
          set ldc_lisaint=Round(ldc_volg*(dateadd(day,-30,ld_maksekuup)-ld_akuup)*ldc_intmaar/36000,2);
          set ldc_intmaar=(ldc_intmaar/li_intervall)/100;
          set ldc_osamaks=Round(ldc_volg/li_kuudearv,2);
          set ldc_const=ldc_volg-(ldc_osamaks*li_kuudearv);
          set ld_akuup=ld_maksekuup;
          while li_jrknr<li_kuudearv and (ld_lkuup is null or ld_akuup<=ld_lkuup) loop
            set li_jrknr=li_jrknr+1;
            set ldc_summa=Round(ldc_volg*ldc_intmaar,2);
            insert into dk_graafik_rida(id_graafik,jrknr,kuup,volg,osamaks,intress) values (a_id_graafik,li_jrknr,ld_akuup,ldc_volg,ldc_osamaks+ldc_const,ldc_summa+ldc_lisaint);
            set ldc_volg=ldc_volg-(ldc_osamaks+ldc_const);
            set ldc_lisaint=0;
            set ldc_const=0;
            set ld_akuup=dateadd(month,li_jrknr*(12/li_intervall),ld_maksekuup);
          end loop
        when 3 then
          set ldc_intmaar=(ldc_intmaar)/100;
          set ldc_osamaks=Round(ldc_volg/li_kuudearv,2);
          set ldc_const=ldc_volg-(ldc_osamaks*li_kuudearv);
          set ldc_summa=Round(ldc_osamaks*ldc_intmaar,2);
          set ld_akuup=ld_maksekuup;
          while li_jrknr<li_kuudearv and (ld_lkuup is null or ld_akuup<=ld_lkuup) loop
            set li_jrknr=li_jrknr+1;
            insert into dk_graafik_rida(id_graafik,jrknr,kuup,volg,osamaks,intress) values (a_id_graafik,li_jrknr,ld_akuup,ldc_volg,ldc_osamaks+ldc_const,ldc_summa);
            set ldc_volg=ldc_volg-(ldc_osamaks+ldc_const);
            set ldc_const=0;
            set ld_akuup=dateadd(month,li_jrknr*(12/li_intervall),ld_maksekuup);
          end loop
      end case
    end if
  end if
END