ALTER PROCEDURE "DBA"."dk_autoviivis_arve"( in a_peralg date, in a_perlop date, in a_arvekuup date, in a_arvenr char(20), in a_asutnr integer, in a_id integer, in a_objnr integer, in a_user_code integer )
BEGIN
  declare ldc_volg numeric(20,6);
  declare ldc_saldo numeric(20,6);
  declare ldc_laek numeric(20,6);
  declare ldc_osamaks numeric(20,6);
  declare ldc_viivis numeric(20,6);
  declare ldc_protsent numeric(20,6);
  declare li_pvi integer;
  declare li_id_graafik integer;
  declare ld_akuup_viivis date;
  declare ld_lkuup_viivis date;
  declare ld_akuup_graafik date;
  declare ld_lkuup_graafik date;
  declare ld_kuup date;
  declare ll_yhiknr integer;
  declare ls_info char(200);
  declare ls_konto char(7);
  declare ll_meetnr integer;
  declare ll_kulnr integer;
  declare ll_talnr integer;
  declare ll_artnr integer;
  declare ll_tulnr integer;
  declare ll_objectnr integer;
  declare ll_osaknr integer;
  declare ll_subjectnr integer;
  declare ll_suundnr integer;
  declare ll_taotnr integer;
  declare ll_alliknr integer;
  declare ll_ravonr integer;
  declare ls_dk_kontod_viivis char(5000);
  declare err_notfound exception for sqlstate value '02000';
  declare c_dk_graafik dynamic scroll cursor for select "dk_graafik"."id", if "dk_graafik"."akuup" < ld_akuup_viivis then ld_akuup_viivis else "dk_graafik"."akuup" endif, if "dk_graafik"."lkuup" is null or "dk_graafik"."lkuup" > ld_lkuup_viivis then ld_lkuup_viivis else "dk_graafik"."lkuup" endif from "dk_graafik" where ("dk_graafik"."arvekuup"=a_arvekuup and "dk_graafik"."arvenr"=a_arvenr and "dk_graafik"."asutnr"=a_asutnr) and "dk_graafik"."akuup" <= ld_lkuup_viivis and ("dk_graafik"."lkuup" >= ld_akuup_viivis or "dk_graafik"."lkuup" is null) order by "dk_graafik"."akuup" ASC;
  declare c_dk_graafik_rida dynamic scroll cursor for select "dk_graafik_rida"."kuup", "dk_graafik_rida"."osamaks" from "dk_graafik_rida" where ("dk_graafik_rida"."id_graafik"=li_id_graafik and "dk_graafik_rida"."kuup">=ld_akuup_graafik and "dk_graafik_rida"."kuup"<=ld_lkuup_graafik) and "dk_graafik_rida"."osamaks"<>0 order by "dk_graafik_rida"."kuup" ASC;
  declare c_gl_dk_viivis dynamic scroll cursor for select gl_dk_viivis.kuup, gl_dk_viivis.arvest, gl_dk_viivis.laek from gl_dk_viivis order by gl_dk_viivis.kuup;
  set ls_dk_kontod_viivis = get_dk_kontod_viivis(0,0);
  set ll_yhiknr = existid_yhiklist('pev');
  delete from gl_dk_viivis;
  select protsent,if "info" is null then '' else Trim("info") endif,konto,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr
   into ldc_protsent, ls_info,ls_konto,ll_meetnr,ll_kulnr,ll_talnr,ll_artnr,ll_tulnr,ll_objectnr,ll_osaknr,ll_subjectnr,ll_suundnr,ll_taotnr,ll_alliknr,ll_ravonr
   from "dk_autoviivis" where "dk_autoviivis"."id" = a_id;
  select date(max(taskuup)+1) into ld_akuup_viivis from "dk_kanne" left outer join "dk_obj" on "dk_kanne"."objnr"="dk_obj"."objnr" where "dk_obj"."viivis"=0 and "dk_obj"."spank"=0 and arvekuup=a_arvekuup and arvenr=a_arvenr and asutnr=a_asutnr;
  if ld_akuup_viivis<a_peralg then
    set ld_akuup_viivis=a_peralg
  end if;
  set ld_lkuup_viivis=a_perlop;
  if ld_lkuup_viivis >= ld_akuup_viivis then
    select sum(if "dk_kanne"."sisse"=1 then ("dk_kanne"."summa"+"dk_kanne"."summa2") else -1*("dk_kanne"."summa"+"dk_kanne"."summa2") endif) into ldc_volg
      from "dk_kanne" left outer join "dk_obj" on "dk_kanne"."objnr"="dk_obj"."objnr"
      where "dk_obj"."viivis"=0 and "dk_obj"."spank"=0 and "dk_kanne"."arvekuup"=a_arvekuup and "dk_kanne"."arvenr"=a_arvenr and "dk_kanne"."asutnr"=a_asutnr;
    if ldc_volg is null then
      set ldc_volg=0
    end if;
    select sum(if "kp_kanne"."sisse"=1 then "kp_kanne"."summa" else -1*("kp_kanne"."summa") endif) into ldc_laek
      from "kp_kanne"
      where ("kp_kanne"."arvekuup"=a_arvekuup and "kp_kanne"."arvenr"=a_arvenr and "kp_kanne"."asutnr"=a_asutnr) AND locate(ls_dk_kontod_viivis,';'+"Left"("kp_kanne"."konto"+Space(7),7)+';') > 0 and "kp_kanne"."kuup"<ld_akuup_viivis;
    if ldc_laek is null then
      set ldc_laek=0
    end if;
    if ldc_volg > ldc_laek then
      set ldc_volg=ldc_volg-ldc_laek;
      insert into gl_dk_viivis ( kuup, laek)
        select kp_kanne.kuup,sum(if kp_kanne.sisse=1 then kp_kanne.summa else -1*(kp_kanne.summa) endif)
          from kp_kanne
          where (kp_kanne.arvekuup=a_arvekuup and kp_kanne.arvenr=a_arvenr and kp_kanne.asutnr=a_asutnr) and locate(ls_dk_kontod_viivis,';'+"Left"(kp_kanne.konto+Space(7),7)+';') > 0 and "kp_kanne"."kuup">=ld_akuup_viivis and "kp_kanne"."kuup"<=ld_lkuup_viivis
          group by "kp_kanne"."kuup"
	      order by "kp_kanne"."kuup" asc;
      if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_akuup_viivis) then
        update gl_dk_viivis set arvest=ldc_volg where gl_dk_viivis.kuup=ld_akuup_viivis
      else
        insert into gl_dk_viivis (kuup, arvest) values (ld_akuup_viivis,ldc_volg)
      end if;
      open c_dk_graafik;
      dk_graafik_loop: loop
        fetch next c_dk_graafik into li_id_graafik, ld_akuup_graafik, ld_lkuup_graafik;
        if sqlstate = err_notfound then -- kui eof
          leave dk_graafik_loop
        end if;
        set ldc_saldo = 0;
        select sum(dk_graafik_rida.osamaks) into ldc_saldo from dk_graafik_rida where dk_graafik_rida.id_graafik=li_id_graafik and dk_graafik_rida.kuup < ld_akuup_graafik;
        if ldc_saldo is null then
          set ldc_saldo=0
        end if;
        set ldc_saldo=ldc_saldo-ldc_laek;
        if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_akuup_graafik) then
          update gl_dk_viivis set arvest=arvest + ldc_saldo - ldc_volg where gl_dk_viivis.kuup=ld_akuup_graafik
        else
          insert into gl_dk_viivis (kuup, arvest) values (ld_akuup_graafik,ldc_saldo-ldc_volg)
        end if;
        open c_dk_graafik_rida;
        dk_graafik_rida_loop: loop
          fetch next c_dk_graafik_rida into ld_kuup, ldc_osamaks;
          if sqlstate = err_notfound then -- kui eof
            leave dk_graafik_rida_loop
          end if;
          set ldc_saldo = ldc_saldo + ldc_osamaks;
          if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_kuup) then
            update gl_dk_viivis set arvest=arvest+ldc_osamaks where gl_dk_viivis.kuup=ld_kuup
          else
            insert into gl_dk_viivis (kuup, arvest) values (ld_kuup,ldc_osamaks)
          end if;
        end loop dk_graafik_rida_loop;
        close c_dk_graafik_rida;
        if ld_lkuup_graafik < ld_lkuup_viivis then
          if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_lkuup_graafik) then
            update gl_dk_viivis set arvest=arvest + ldc_volg - ldc_saldo where gl_dk_viivis.kuup=ld_lkuup_graafik
          else
            insert into gl_dk_viivis (kuup, arvest) values (ld_lkuup_graafik,ldc_volg - ldc_saldo)
          end if
        end if
      end loop dk_graafik_loop;
      close c_dk_graafik;
      set ldc_volg = 0;
      open c_gl_dk_viivis;
      gl_dk_viivis_loop: loop
        fetch next c_gl_dk_viivis into ld_kuup, ldc_osamaks, ldc_laek;
        if sqlstate = err_notfound then -- kui eof
          leave gl_dk_viivis_loop
        end if;
        set ldc_viivis = 0;
        set li_pvi = DateDiff(day, ld_akuup_viivis, ld_kuup);
        set ld_akuup_viivis = ld_kuup;
        if li_pvi > 0 then
          set ldc_viivis = Round(ldc_volg * li_pvi * ldc_protsent / 36000,2);
        end if;
        set ldc_volg = ldc_volg + ldc_osamaks - ldc_laek;
        update gl_dk_viivis set volg=ldc_volg, pvi=li_pvi, viivis=ldc_viivis where kuup=ld_kuup;
      end loop gl_dk_viivis_loop;
      close c_gl_dk_viivis;
      if ldc_volg > 0 then
        set ldc_viivis = 0;
        set li_pvi = DateDiff(day, ld_akuup_viivis, ld_lkuup_viivis) + 1;
        if li_pvi > 0 then
          set ldc_viivis = Round(ldc_volg * li_pvi * ldc_protsent / 36000,2);
        end if;
        if exists( select 1 from gl_dk_viivis where gl_dk_viivis.kuup = ld_lkuup_viivis) then
          update gl_dk_viivis set pvi=pvi+li_pvi, viivis=viivis+ldc_viivis where kuup=ld_lkuup_viivis
        else
          insert into gl_dk_viivis (kuup,volg,pvi,viivis) values (ld_lkuup_viivis,ldc_volg,li_pvi,ldc_viivis)
        end if
      end if;
      insert into gl_dk_kanne( objnr,tulnud,sisse,kuup,arvekuup,taskuup,kogus,yhiknr,hind,summa,summa2,"info",asutnr,konto,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,user_code)
        select a_objnr,'AutoViivis',1,a_perlop,a_perlop,a_perlop,gl_dk_viivis.pvi,ll_yhiknr,Round(gl_dk_viivis.viivis/gl_dk_viivis.pvi,3),gl_dk_viivis.viivis,0,'Arvestatud viivis '+convert(char(14),"gl_dk_viivis"."kuup",104)+'  Arve nr.'+a_arvenr+' '+convert(char(14),a_arvekuup,104)+'  '+ls_info, a_asutnr, ls_konto,ll_meetnr, ll_kulnr, ll_talnr, ll_artnr, ll_tulnr, ll_objectnr, ll_osaknr, ll_subjectnr, ll_suundnr, ll_taotnr, ll_alliknr, ll_ravonr, a_user_code
        from gl_dk_viivis where gl_dk_viivis.viivis <> 0 order by kuup asc;
    end if
  end if
END