CREATE PROCEDURE "dba"."dk_arvetas2024"( in a_skoopkood char(16) default '',in id_skoop integer default 0,in id_obj integer default 0,in id_paring integer default 0,in a_spank smallint default 0,in id_dk_per smallint default 0,in perlop date default ymd(2024,12,31), in gl_id_user integer default 32767, in a_form smallint default 0 )
BEGIN
  declare dk_perlop date;
  declare ls_dk_kontod char(5000);
  declare li_asutnr integer;
  declare li_old_asutnr integer;
  declare ld_arvekuup date;
  declare ld_old_arvekuup date;
  declare ls_arvenr char(20);
  declare ls_old_arvenr char(20);
  declare ld_taskuup date;
  declare ldc_arvesumma numeric(15,2);
  declare ldc_makssumma numeric(15,2);
  declare ldc_jaak numeric(15,2);
  declare ll_id integer;
  declare ll_old_id integer;
  declare li_paring integer;
  declare err_notfound exception for sqlstate value '02000';

  declare c_koond dynamic scroll cursor for
    select "id",asutnr,arvekuup,arvenr,taskuup,arvesumma,makssumma
      from gl_dk_arvetas2007
      order by asutnr asc,arvekuup asc,arvenr asc, taskuup asc;


  delete from gl_dk_arvetas2007;
  delete from gl_dk_arvetas;

  select if tr_dk_arvetas_pvi=0 then perlop else tr_dk_arvetas_perlop endif into dk_perlop from t_user where id_user=gl_id_user;
  if dk_perlop is null then
    set dk_perlop=perlop
  end if;

  set li_paring=set_gl_1(id_paring);

    -- arvelduste kanded
    case id_dk_per
    when 0 then
      insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,taskuup,arvesumma,makssumma)
        select dk_kanne.asutnr,
               if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
               if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
               Max(dk_kanne.taskuup),
               sum(if dk_kanne.sisse=a_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif),
               0
          from dk_kanne left outer join gl_1 on(dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) key left outer join dk_obj, dk_obj key left outer join skoobid
          where ((dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) or id_paring = 0) and
                (Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and (dk_obj.skoop = id_skoop or id_skoop = 0)) and
                (dk_kanne.objnr = id_obj or id_obj = 0) and
                dk_obj.spank=a_spank and
                dk_kanne.asutnr > 0 and
                dk_kanne.kuup <= dk_perlop
          group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
    when 1 then
      insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,taskuup,arvesumma,makssumma)
        select dk_kanne.asutnr,
               if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
               if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
               Max(dk_kanne.taskuup),
               sum(if dk_kanne.sisse=a_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif),
               0
          from dk_kanne left outer join gl_1 on(dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) key left outer join dk_obj, dk_obj key left outer join skoobid
          where ((dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) or id_paring = 0) and
                (Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and (dk_obj.skoop = id_skoop or id_skoop = 0)) and
                (dk_kanne.objnr = id_obj or id_obj = 0) and
                dk_obj.spank=a_spank and
                dk_kanne.asutnr > 0 and
                dk_kanne.arvekuup <= dk_perlop
          group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
    when 2 then
      insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,taskuup,arvesumma,makssumma)
        select dk_kanne.asutnr,
               if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
               if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
               Max(dk_kanne.taskuup),
               sum(if dk_kanne.sisse=a_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif),
               0
          from dk_kanne left outer join gl_1 on(dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) key left outer join dk_obj, dk_obj key left outer join skoobid
          where ((dk_kanne.id = gl_1.id) and(dk_kanne.kuup = gl_1.kuup) or id_paring = 0) and
                (Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and (dk_obj.skoop = id_skoop or id_skoop = 0)) and
                (dk_kanne.objnr = id_obj or id_obj = 0) and
                dk_obj.spank=a_spank and
                dk_kanne.asutnr > 0 and
                dk_kanne.taskuup <= dk_perlop
          group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
    end case;
    -- kassa panga kanded
    set ls_dk_kontod=get_dk_kontod_spank(id_skoop,a_spank,id_obj);
    set li_paring=set_gl_1_conv_dk_kp(id_paring);
    insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,makssumma,taskuup,arvesumma)
      select kp_kanne.asutnr,
             if kp_kanne.arvenr is null then '' else kp_kanne.arvenr endif as kp_kanne_arvenr,
             if kp_kanne.arvekuup is null then ymd(2000,1,1) else kp_kanne.arvekuup endif as kp_kanne_arvekuup,
             sum(if kp_kanne.sisse=a_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif),
             ymd(1999,1,1),
             0
        from kp_kanne left outer join gl_1 on(kp_kanne.id = gl_1.id) and(kp_kanne.kuup = gl_1.kuup) key left outer join kp_obj, kp_obj key left outer join skoobid
        where ((kp_kanne.id = gl_1.id) and(kp_kanne.kuup = gl_1.kuup) or id_paring = 0) and
              (Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and (kp_obj.skoop = id_skoop or id_skoop = 0)) and
               locate(ls_dk_kontod,';'+"Left"(kp_kanne.konto+Space(7),7)+';') > 0 and
               kp_kanne.asutnr > 0 and kp_kanne.kuup <= perlop
        group by kp_kanne.asutnr,kp_kanne_arvekuup,kp_kanne_arvenr;
  -- koond
    insert into gl_dk_arvetas2007( asutnr,arvenr,arvekuup,makssumma,taskuup,arvesumma)
      select asutnr,arvenr,arvekuup,sum(makssumma),max(taskuup),sum(arvesumma)
      from gl_dk_arvetas
      group by asutnr,arvekuup,arvenr;



  delete from gl_dk_arvetas2007 where arvesumma=makssumma;

  update gl_dk_arvetas2007 set volg=arvesumma-makssumma;

  update gl_dk_arvetas2007 set kulnr=datediff(month,taskuup,perlop), talnr=datediff(day,taskuup,perlop) where volg>0;

  if a_form=90 or a_form=91 then
    delete from gl_dk_arvetas2007 where volg<=0;
  end if;
  if a_form=91 then
    delete from gl_dk_arvetas2007 where kulnr<3;
  end if;



END